/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.PrincipalRateLimitEntity;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class PrincipalRateLimitApi {
    private ApiClient apiClient;

    public PrincipalRateLimitApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PrincipalRateLimitApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public PrincipalRateLimitEntity createPrincipalRateLimitEntity(PrincipalRateLimitEntity entity) throws ApiException {
        return this.createPrincipalRateLimitEntity(entity, Collections.emptyMap());
    }

    public PrincipalRateLimitEntity createPrincipalRateLimitEntity(PrincipalRateLimitEntity entity, Map<String, String> additionalHeaders) throws ApiException {
        PrincipalRateLimitEntity localVarPostBody = entity;
        if (entity == null) {
            throw new ApiException(400, "Missing the required parameter 'entity' when calling createPrincipalRateLimitEntity");
        }
        String localVarPath = "/api/v1/principal-rate-limits";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<PrincipalRateLimitEntity> localVarReturnType = new TypeReference<PrincipalRateLimitEntity>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public PrincipalRateLimitEntity getPrincipalRateLimitEntity(String principalRateLimitId) throws ApiException {
        return this.getPrincipalRateLimitEntity(principalRateLimitId, Collections.emptyMap());
    }

    public PrincipalRateLimitEntity getPrincipalRateLimitEntity(String principalRateLimitId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (principalRateLimitId == null) {
            throw new ApiException(400, "Missing the required parameter 'principalRateLimitId' when calling getPrincipalRateLimitEntity");
        }
        String localVarPath = "/api/v1/principal-rate-limits/{principalRateLimitId}".replaceAll("\\{principalRateLimitId\\}", this.apiClient.escapeString(principalRateLimitId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<PrincipalRateLimitEntity> localVarReturnType = new TypeReference<PrincipalRateLimitEntity>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<PrincipalRateLimitEntity> listPrincipalRateLimitEntities(String filter, String after, Integer limit) throws ApiException {
        return this.listPrincipalRateLimitEntities(filter, after, limit, Collections.emptyMap());
    }

    public List<PrincipalRateLimitEntity> listPrincipalRateLimitEntities(String filter, String after, Integer limit, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/principal-rate-limits";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<PrincipalRateLimitEntity>> localVarReturnType = new TypeReference<List<PrincipalRateLimitEntity>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public PrincipalRateLimitEntity replacePrincipalRateLimitEntity(String principalRateLimitId, PrincipalRateLimitEntity entity) throws ApiException {
        return this.replacePrincipalRateLimitEntity(principalRateLimitId, entity, Collections.emptyMap());
    }

    public PrincipalRateLimitEntity replacePrincipalRateLimitEntity(String principalRateLimitId, PrincipalRateLimitEntity entity, Map<String, String> additionalHeaders) throws ApiException {
        PrincipalRateLimitEntity localVarPostBody = entity;
        if (principalRateLimitId == null) {
            throw new ApiException(400, "Missing the required parameter 'principalRateLimitId' when calling replacePrincipalRateLimitEntity");
        }
        if (entity == null) {
            throw new ApiException(400, "Missing the required parameter 'entity' when calling replacePrincipalRateLimitEntity");
        }
        String localVarPath = "/api/v1/principal-rate-limits/{principalRateLimitId}".replaceAll("\\{principalRateLimitId\\}", this.apiClient.escapeString(principalRateLimitId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<PrincipalRateLimitEntity> localVarReturnType = new TypeReference<PrincipalRateLimitEntity>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

