/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.BulkDeleteRequestBody;
import org.openapitools.client.model.BulkUpsertRequestBody;
import org.openapitools.client.model.IdentitySourceSession;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class IdentitySourceApi {
    private ApiClient apiClient;

    public IdentitySourceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public IdentitySourceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public List<IdentitySourceSession> createIdentitySourceSession(String identitySourceId) throws ApiException {
        return this.createIdentitySourceSession(identitySourceId, Collections.emptyMap());
    }

    public List<IdentitySourceSession> createIdentitySourceSession(String identitySourceId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (identitySourceId == null) {
            throw new ApiException(400, "Missing the required parameter 'identitySourceId' when calling createIdentitySourceSession");
        }
        String localVarPath = "/api/v1/identity-sources/{identitySourceId}/sessions".replaceAll("\\{identitySourceId\\}", this.apiClient.escapeString(identitySourceId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<IdentitySourceSession>> localVarReturnType = new TypeReference<List<IdentitySourceSession>>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteIdentitySourceSession(String identitySourceId, String sessionId) throws ApiException {
        this.deleteIdentitySourceSession(identitySourceId, sessionId, Collections.emptyMap());
    }

    public void deleteIdentitySourceSession(String identitySourceId, String sessionId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (identitySourceId == null) {
            throw new ApiException(400, "Missing the required parameter 'identitySourceId' when calling deleteIdentitySourceSession");
        }
        if (sessionId == null) {
            throw new ApiException(400, "Missing the required parameter 'sessionId' when calling deleteIdentitySourceSession");
        }
        String localVarPath = "/api/v1/identity-sources/{identitySourceId}/sessions/{sessionId}".replaceAll("\\{identitySourceId\\}", this.apiClient.escapeString(identitySourceId.toString())).replaceAll("\\{sessionId\\}", this.apiClient.escapeString(sessionId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public IdentitySourceSession getIdentitySourceSession(String identitySourceId, String sessionId) throws ApiException {
        return this.getIdentitySourceSession(identitySourceId, sessionId, Collections.emptyMap());
    }

    public IdentitySourceSession getIdentitySourceSession(String identitySourceId, String sessionId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (identitySourceId == null) {
            throw new ApiException(400, "Missing the required parameter 'identitySourceId' when calling getIdentitySourceSession");
        }
        if (sessionId == null) {
            throw new ApiException(400, "Missing the required parameter 'sessionId' when calling getIdentitySourceSession");
        }
        String localVarPath = "/api/v1/identity-sources/{identitySourceId}/sessions/{sessionId}".replaceAll("\\{identitySourceId\\}", this.apiClient.escapeString(identitySourceId.toString())).replaceAll("\\{sessionId\\}", this.apiClient.escapeString(sessionId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<IdentitySourceSession> localVarReturnType = new TypeReference<IdentitySourceSession>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<IdentitySourceSession> listIdentitySourceSessions(String identitySourceId) throws ApiException {
        return this.listIdentitySourceSessions(identitySourceId, Collections.emptyMap());
    }

    public List<IdentitySourceSession> listIdentitySourceSessions(String identitySourceId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (identitySourceId == null) {
            throw new ApiException(400, "Missing the required parameter 'identitySourceId' when calling listIdentitySourceSessions");
        }
        String localVarPath = "/api/v1/identity-sources/{identitySourceId}/sessions".replaceAll("\\{identitySourceId\\}", this.apiClient.escapeString(identitySourceId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<IdentitySourceSession>> localVarReturnType = new TypeReference<List<IdentitySourceSession>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<IdentitySourceSession> startImportFromIdentitySource(String identitySourceId, String sessionId) throws ApiException {
        return this.startImportFromIdentitySource(identitySourceId, sessionId, Collections.emptyMap());
    }

    public List<IdentitySourceSession> startImportFromIdentitySource(String identitySourceId, String sessionId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (identitySourceId == null) {
            throw new ApiException(400, "Missing the required parameter 'identitySourceId' when calling startImportFromIdentitySource");
        }
        if (sessionId == null) {
            throw new ApiException(400, "Missing the required parameter 'sessionId' when calling startImportFromIdentitySource");
        }
        String localVarPath = "/api/v1/identity-sources/{identitySourceId}/sessions/{sessionId}/start-import".replaceAll("\\{identitySourceId\\}", this.apiClient.escapeString(identitySourceId.toString())).replaceAll("\\{sessionId\\}", this.apiClient.escapeString(sessionId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<IdentitySourceSession>> localVarReturnType = new TypeReference<List<IdentitySourceSession>>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void uploadIdentitySourceDataForDelete(String identitySourceId, String sessionId, BulkDeleteRequestBody bulkDeleteRequestBody) throws ApiException {
        this.uploadIdentitySourceDataForDelete(identitySourceId, sessionId, bulkDeleteRequestBody, Collections.emptyMap());
    }

    public void uploadIdentitySourceDataForDelete(String identitySourceId, String sessionId, BulkDeleteRequestBody bulkDeleteRequestBody, Map<String, String> additionalHeaders) throws ApiException {
        BulkDeleteRequestBody localVarPostBody = bulkDeleteRequestBody;
        if (identitySourceId == null) {
            throw new ApiException(400, "Missing the required parameter 'identitySourceId' when calling uploadIdentitySourceDataForDelete");
        }
        if (sessionId == null) {
            throw new ApiException(400, "Missing the required parameter 'sessionId' when calling uploadIdentitySourceDataForDelete");
        }
        String localVarPath = "/api/v1/identity-sources/{identitySourceId}/sessions/{sessionId}/bulk-delete".replaceAll("\\{identitySourceId\\}", this.apiClient.escapeString(identitySourceId.toString())).replaceAll("\\{sessionId\\}", this.apiClient.escapeString(sessionId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void uploadIdentitySourceDataForUpsert(String identitySourceId, String sessionId, BulkUpsertRequestBody bulkUpsertRequestBody) throws ApiException {
        this.uploadIdentitySourceDataForUpsert(identitySourceId, sessionId, bulkUpsertRequestBody, Collections.emptyMap());
    }

    public void uploadIdentitySourceDataForUpsert(String identitySourceId, String sessionId, BulkUpsertRequestBody bulkUpsertRequestBody, Map<String, String> additionalHeaders) throws ApiException {
        BulkUpsertRequestBody localVarPostBody = bulkUpsertRequestBody;
        if (identitySourceId == null) {
            throw new ApiException(400, "Missing the required parameter 'identitySourceId' when calling uploadIdentitySourceDataForUpsert");
        }
        if (sessionId == null) {
            throw new ApiException(400, "Missing the required parameter 'sessionId' when calling uploadIdentitySourceDataForUpsert");
        }
        String localVarPath = "/api/v1/identity-sources/{identitySourceId}/sessions/{sessionId}/bulk-upsert".replaceAll("\\{identitySourceId\\}", this.apiClient.escapeString(identitySourceId.toString())).replaceAll("\\{sessionId\\}", this.apiClient.escapeString(sessionId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

