/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.Authenticator;
import org.openapitools.client.model.AuthenticatorMethodBase;
import org.openapitools.client.model.AuthenticatorMethodType;
import org.openapitools.client.model.WellKnownAppAuthenticatorConfiguration;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class AuthenticatorApi {
    private ApiClient apiClient;

    public AuthenticatorApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AuthenticatorApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Authenticator activateAuthenticator(String authenticatorId) throws ApiException {
        return this.activateAuthenticator(authenticatorId, Collections.emptyMap());
    }

    public Authenticator activateAuthenticator(String authenticatorId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authenticatorId == null) {
            throw new ApiException(400, "Missing the required parameter 'authenticatorId' when calling activateAuthenticator");
        }
        String localVarPath = "/api/v1/authenticators/{authenticatorId}/lifecycle/activate".replaceAll("\\{authenticatorId\\}", this.apiClient.escapeString(authenticatorId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<Authenticator> localVarReturnType = new TypeReference<Authenticator>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AuthenticatorMethodBase activateAuthenticatorMethod(String authenticatorId, AuthenticatorMethodType methodType) throws ApiException {
        return this.activateAuthenticatorMethod(authenticatorId, methodType, Collections.emptyMap());
    }

    public AuthenticatorMethodBase activateAuthenticatorMethod(String authenticatorId, AuthenticatorMethodType methodType, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authenticatorId == null) {
            throw new ApiException(400, "Missing the required parameter 'authenticatorId' when calling activateAuthenticatorMethod");
        }
        if (methodType == null) {
            throw new ApiException(400, "Missing the required parameter 'methodType' when calling activateAuthenticatorMethod");
        }
        String localVarPath = "/api/v1/authenticators/{authenticatorId}/methods/{methodType}/lifecycle/activate".replaceAll("\\{authenticatorId\\}", this.apiClient.escapeString(authenticatorId.toString())).replaceAll("\\{methodType\\}", this.apiClient.escapeString(methodType.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AuthenticatorMethodBase> localVarReturnType = new TypeReference<AuthenticatorMethodBase>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Authenticator createAuthenticator(Authenticator authenticator, Boolean activate) throws ApiException {
        return this.createAuthenticator(authenticator, activate, Collections.emptyMap());
    }

    public Authenticator createAuthenticator(Authenticator authenticator, Boolean activate, Map<String, String> additionalHeaders) throws ApiException {
        Authenticator localVarPostBody = authenticator;
        if (authenticator == null) {
            throw new ApiException(400, "Missing the required parameter 'authenticator' when calling createAuthenticator");
        }
        String localVarPath = "/api/v1/authenticators";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("activate", activate));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<Authenticator> localVarReturnType = new TypeReference<Authenticator>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Authenticator deactivateAuthenticator(String authenticatorId) throws ApiException {
        return this.deactivateAuthenticator(authenticatorId, Collections.emptyMap());
    }

    public Authenticator deactivateAuthenticator(String authenticatorId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authenticatorId == null) {
            throw new ApiException(400, "Missing the required parameter 'authenticatorId' when calling deactivateAuthenticator");
        }
        String localVarPath = "/api/v1/authenticators/{authenticatorId}/lifecycle/deactivate".replaceAll("\\{authenticatorId\\}", this.apiClient.escapeString(authenticatorId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<Authenticator> localVarReturnType = new TypeReference<Authenticator>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AuthenticatorMethodBase deactivateAuthenticatorMethod(String authenticatorId, AuthenticatorMethodType methodType) throws ApiException {
        return this.deactivateAuthenticatorMethod(authenticatorId, methodType, Collections.emptyMap());
    }

    public AuthenticatorMethodBase deactivateAuthenticatorMethod(String authenticatorId, AuthenticatorMethodType methodType, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authenticatorId == null) {
            throw new ApiException(400, "Missing the required parameter 'authenticatorId' when calling deactivateAuthenticatorMethod");
        }
        if (methodType == null) {
            throw new ApiException(400, "Missing the required parameter 'methodType' when calling deactivateAuthenticatorMethod");
        }
        String localVarPath = "/api/v1/authenticators/{authenticatorId}/methods/{methodType}/lifecycle/deactivate".replaceAll("\\{authenticatorId\\}", this.apiClient.escapeString(authenticatorId.toString())).replaceAll("\\{methodType\\}", this.apiClient.escapeString(methodType.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AuthenticatorMethodBase> localVarReturnType = new TypeReference<AuthenticatorMethodBase>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Authenticator getAuthenticator(String authenticatorId) throws ApiException {
        return this.getAuthenticator(authenticatorId, Collections.emptyMap());
    }

    public Authenticator getAuthenticator(String authenticatorId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authenticatorId == null) {
            throw new ApiException(400, "Missing the required parameter 'authenticatorId' when calling getAuthenticator");
        }
        String localVarPath = "/api/v1/authenticators/{authenticatorId}".replaceAll("\\{authenticatorId\\}", this.apiClient.escapeString(authenticatorId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<Authenticator> localVarReturnType = new TypeReference<Authenticator>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AuthenticatorMethodBase getAuthenticatorMethod(String authenticatorId, AuthenticatorMethodType methodType) throws ApiException {
        return this.getAuthenticatorMethod(authenticatorId, methodType, Collections.emptyMap());
    }

    public AuthenticatorMethodBase getAuthenticatorMethod(String authenticatorId, AuthenticatorMethodType methodType, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authenticatorId == null) {
            throw new ApiException(400, "Missing the required parameter 'authenticatorId' when calling getAuthenticatorMethod");
        }
        if (methodType == null) {
            throw new ApiException(400, "Missing the required parameter 'methodType' when calling getAuthenticatorMethod");
        }
        String localVarPath = "/api/v1/authenticators/{authenticatorId}/methods/{methodType}".replaceAll("\\{authenticatorId\\}", this.apiClient.escapeString(authenticatorId.toString())).replaceAll("\\{methodType\\}", this.apiClient.escapeString(methodType.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AuthenticatorMethodBase> localVarReturnType = new TypeReference<AuthenticatorMethodBase>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<WellKnownAppAuthenticatorConfiguration> getWellKnownAppAuthenticatorConfiguration(String oauthClientId) throws ApiException {
        return this.getWellKnownAppAuthenticatorConfiguration(oauthClientId, Collections.emptyMap());
    }

    public List<WellKnownAppAuthenticatorConfiguration> getWellKnownAppAuthenticatorConfiguration(String oauthClientId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (oauthClientId == null) {
            throw new ApiException(400, "Missing the required parameter 'oauthClientId' when calling getWellKnownAppAuthenticatorConfiguration");
        }
        String localVarPath = "/.well-known/app-authenticator-configuration";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("oauthClientId", oauthClientId));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        TypeReference<List<WellKnownAppAuthenticatorConfiguration>> localVarReturnType = new TypeReference<List<WellKnownAppAuthenticatorConfiguration>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<AuthenticatorMethodBase> listAuthenticatorMethods(String authenticatorId) throws ApiException {
        return this.listAuthenticatorMethods(authenticatorId, Collections.emptyMap());
    }

    public List<AuthenticatorMethodBase> listAuthenticatorMethods(String authenticatorId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authenticatorId == null) {
            throw new ApiException(400, "Missing the required parameter 'authenticatorId' when calling listAuthenticatorMethods");
        }
        String localVarPath = "/api/v1/authenticators/{authenticatorId}/methods".replaceAll("\\{authenticatorId\\}", this.apiClient.escapeString(authenticatorId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<AuthenticatorMethodBase>> localVarReturnType = new TypeReference<List<AuthenticatorMethodBase>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<Authenticator> listAuthenticators() throws ApiException {
        return this.listAuthenticators(Collections.emptyMap());
    }

    public List<Authenticator> listAuthenticators(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/authenticators";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<Authenticator>> localVarReturnType = new TypeReference<List<Authenticator>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Authenticator replaceAuthenticator(String authenticatorId, Authenticator authenticator) throws ApiException {
        return this.replaceAuthenticator(authenticatorId, authenticator, Collections.emptyMap());
    }

    public Authenticator replaceAuthenticator(String authenticatorId, Authenticator authenticator, Map<String, String> additionalHeaders) throws ApiException {
        Authenticator localVarPostBody = authenticator;
        if (authenticatorId == null) {
            throw new ApiException(400, "Missing the required parameter 'authenticatorId' when calling replaceAuthenticator");
        }
        if (authenticator == null) {
            throw new ApiException(400, "Missing the required parameter 'authenticator' when calling replaceAuthenticator");
        }
        String localVarPath = "/api/v1/authenticators/{authenticatorId}".replaceAll("\\{authenticatorId\\}", this.apiClient.escapeString(authenticatorId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<Authenticator> localVarReturnType = new TypeReference<Authenticator>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AuthenticatorMethodBase replaceAuthenticatorMethod(String authenticatorId, AuthenticatorMethodType methodType, AuthenticatorMethodBase authenticatorMethodBase) throws ApiException {
        return this.replaceAuthenticatorMethod(authenticatorId, methodType, authenticatorMethodBase, Collections.emptyMap());
    }

    public AuthenticatorMethodBase replaceAuthenticatorMethod(String authenticatorId, AuthenticatorMethodType methodType, AuthenticatorMethodBase authenticatorMethodBase, Map<String, String> additionalHeaders) throws ApiException {
        AuthenticatorMethodBase localVarPostBody = authenticatorMethodBase;
        if (authenticatorId == null) {
            throw new ApiException(400, "Missing the required parameter 'authenticatorId' when calling replaceAuthenticatorMethod");
        }
        if (methodType == null) {
            throw new ApiException(400, "Missing the required parameter 'methodType' when calling replaceAuthenticatorMethod");
        }
        String localVarPath = "/api/v1/authenticators/{authenticatorId}/methods/{methodType}".replaceAll("\\{authenticatorId\\}", this.apiClient.escapeString(authenticatorId.toString())).replaceAll("\\{methodType\\}", this.apiClient.escapeString(methodType.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AuthenticatorMethodBase> localVarReturnType = new TypeReference<AuthenticatorMethodBase>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

