/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

@JsonPropertyOrder(value={"grantedScopes", "type"})
@JsonTypeName(value="postAPIServiceIntegrationInstanceRequest")
public class PostAPIServiceIntegrationInstanceRequest {
    public static final String JSON_PROPERTY_GRANTED_SCOPES = "grantedScopes";
    private List<String> grantedScopes = new ArrayList<String>();
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public PostAPIServiceIntegrationInstanceRequest grantedScopes(List<String> grantedScopes) {
        this.grantedScopes = grantedScopes;
        return this;
    }

    public PostAPIServiceIntegrationInstanceRequest addGrantedScopesItem(String grantedScopesItem) {
        if (this.grantedScopes == null) {
            this.grantedScopes = new ArrayList<String>();
        }
        this.grantedScopes.add(grantedScopesItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="[\"okta.logs.read\"]", required=true, value="The list of Okta management scopes granted to the API Service Integration instance. See [Okta management OAuth 2.0 scopes](/oauth2/#okta-admin-management).")
    @JsonProperty(value="grantedScopes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getGrantedScopes() {
        return this.grantedScopes;
    }

    @JsonProperty(value="grantedScopes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setGrantedScopes(List<String> grantedScopes) {
        this.grantedScopes = grantedScopes;
    }

    public PostAPIServiceIntegrationInstanceRequest type(String type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="my_app_cie", required=true, value="The type of the API service integration. This string is an underscore-concatenated, lowercased API service integration name. For example, `my_api_log_integration`.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostAPIServiceIntegrationInstanceRequest postAPIServiceIntegrationInstanceRequest = (PostAPIServiceIntegrationInstanceRequest)o;
        return Objects.equals(this.grantedScopes, postAPIServiceIntegrationInstanceRequest.grantedScopes) && Objects.equals(this.type, postAPIServiceIntegrationInstanceRequest.type);
    }

    public int hashCode() {
        return Objects.hash(this.grantedScopes, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostAPIServiceIntegrationInstanceRequest {\n");
        sb.append("    grantedScopes: ").append(this.toIndentedString(this.grantedScopes)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

