/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum NotificationType {
    AD_AGENT("AD_AGENT"),
    AGENT_AUTO_UPDATE_NOTIFICATION("AGENT_AUTO_UPDATE_NOTIFICATION"),
    APP_IMPORT("APP_IMPORT"),
    CONNECTOR_AGENT("CONNECTOR_AGENT"),
    IWA_AGENT("IWA_AGENT"),
    LDAP_AGENT("LDAP_AGENT"),
    OKTA_ANNOUNCEMENT("OKTA_ANNOUNCEMENT"),
    OKTA_ISSUE("OKTA_ISSUE"),
    OKTA_UPDATE("OKTA_UPDATE"),
    RATELIMIT_NOTIFICATION("RATELIMIT_NOTIFICATION"),
    REPORT_SUSPICIOUS_ACTIVITY("REPORT_SUSPICIOUS_ACTIVITY"),
    USER_DEPROVISION("USER_DEPROVISION"),
    USER_LOCKED_OUT("USER_LOCKED_OUT");

    private String value;

    private NotificationType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static NotificationType fromValue(String value) {
        for (NotificationType b : NotificationType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        return String.format("%s=%s", prefix, this.toString());
    }
}

