/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.model.APIServiceIntegrationLinks;

@JsonPropertyOrder(value={"configGuideUrl", "createdAt", "createdBy", "grantedScopes", "id", "name", "type", "_links"})
public class APIServiceIntegrationInstance {
    public static final String JSON_PROPERTY_CONFIG_GUIDE_URL = "configGuideUrl";
    private String configGuideUrl;
    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    private String createdAt;
    public static final String JSON_PROPERTY_CREATED_BY = "createdBy";
    private String createdBy;
    public static final String JSON_PROPERTY_GRANTED_SCOPES = "grantedScopes";
    private List<String> grantedScopes = null;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private APIServiceIntegrationLinks links;

    @Nullable
    @ApiModelProperty(example="https://{docDomain}/my-app-cie/configuration-guide", value="The URL to the API service integration configuration guide")
    @JsonProperty(value="configGuideUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getConfigGuideUrl() {
        return this.configGuideUrl;
    }

    @Nullable
    @ApiModelProperty(example="2023-02-21T20:08:24.000Z", value="Timestamp when the API Service Integration instance was created")
    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @Nullable
    @ApiModelProperty(example="00uu3u0ujW1P6AfZC2d5", value="The user ID of the API Service Integration instance creator")
    @JsonProperty(value="createdBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCreatedBy() {
        return this.createdBy;
    }

    public APIServiceIntegrationInstance grantedScopes(List<String> grantedScopes) {
        this.grantedScopes = grantedScopes;
        return this;
    }

    public APIServiceIntegrationInstance addGrantedScopesItem(String grantedScopesItem) {
        if (this.grantedScopes == null) {
            this.grantedScopes = new ArrayList<String>();
        }
        this.grantedScopes.add(grantedScopesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"okta.logs.read\"]", value="The list of Okta management scopes granted to the API Service Integration instance. See [Okta management OAuth 2.0 scopes](/oauth2/#okta-admin-management).")
    @JsonProperty(value="grantedScopes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getGrantedScopes() {
        return this.grantedScopes;
    }

    @JsonProperty(value="grantedScopes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGrantedScopes(List<String> grantedScopes) {
        this.grantedScopes = grantedScopes;
    }

    @Nullable
    @ApiModelProperty(example="0oa72lrepvp4WqEET1d9", value="The ID of the API Service Integration instance")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(example="My App Cloud Identity Engine", value="The name of the API service integration that corresponds with the `type` property. This is the full name of the API service integration listed in the Okta Integration Network (OIN) catalog.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public APIServiceIntegrationInstance type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="my_app_cie", value="The type of the API service integration. This string is an underscore-concatenated, lowercased API service integration name. For example, `my_api_log_integration`.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    public APIServiceIntegrationInstance links(APIServiceIntegrationLinks links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public APIServiceIntegrationLinks getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(APIServiceIntegrationLinks links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        APIServiceIntegrationInstance apIServiceIntegrationInstance = (APIServiceIntegrationInstance)o;
        return Objects.equals(this.configGuideUrl, apIServiceIntegrationInstance.configGuideUrl) && Objects.equals(this.createdAt, apIServiceIntegrationInstance.createdAt) && Objects.equals(this.createdBy, apIServiceIntegrationInstance.createdBy) && Objects.equals(this.grantedScopes, apIServiceIntegrationInstance.grantedScopes) && Objects.equals(this.id, apIServiceIntegrationInstance.id) && Objects.equals(this.name, apIServiceIntegrationInstance.name) && Objects.equals(this.type, apIServiceIntegrationInstance.type) && Objects.equals(this.links, apIServiceIntegrationInstance.links);
    }

    public int hashCode() {
        return Objects.hash(this.configGuideUrl, this.createdAt, this.createdBy, this.grantedScopes, this.id, this.name, this.type, this.links);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class APIServiceIntegrationInstance {\n");
        sb.append("    configGuideUrl: ").append(this.toIndentedString(this.configGuideUrl)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    grantedScopes: ").append(this.toIndentedString(this.grantedScopes)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

