/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.AppUser;
import org.openapitools.client.model.Application;
import org.openapitools.client.model.ApplicationFeature;
import org.openapitools.client.model.ApplicationGroupAssignment;
import org.openapitools.client.model.CapabilitiesObject;
import org.openapitools.client.model.Csr;
import org.openapitools.client.model.CsrMetadata;
import org.openapitools.client.model.JsonWebKey;
import org.openapitools.client.model.OAuth2ScopeConsentGrant;
import org.openapitools.client.model.OAuth2Token;
import org.openapitools.client.model.ProvisioningConnection;
import org.openapitools.client.model.ProvisioningConnectionRequest;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class ApplicationApi {
    private ApiClient apiClient;

    public ApplicationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApplicationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void activateApplication(String appId) throws ApiException {
        this.activateApplication(appId, Collections.emptyMap());
    }

    public void activateApplication(String appId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling activateApplication");
        }
        String localVarPath = "/api/v1/apps/{appId}/lifecycle/activate".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void activateDefaultProvisioningConnectionForApplication(String appId) throws ApiException {
        this.activateDefaultProvisioningConnectionForApplication(appId, Collections.emptyMap());
    }

    public void activateDefaultProvisioningConnectionForApplication(String appId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling activateDefaultProvisioningConnectionForApplication");
        }
        String localVarPath = "/api/v1/apps/{appId}/connections/default/lifecycle/activate".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void assignApplicationPolicy(String appId, String policyId) throws ApiException {
        this.assignApplicationPolicy(appId, policyId, Collections.emptyMap());
    }

    public void assignApplicationPolicy(String appId, String policyId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling assignApplicationPolicy");
        }
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling assignApplicationPolicy");
        }
        String localVarPath = "/api/v1/apps/{appId}/policies/{policyId}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public ApplicationGroupAssignment assignGroupToApplication(String appId, String groupId, ApplicationGroupAssignment applicationGroupAssignment) throws ApiException {
        return this.assignGroupToApplication(appId, groupId, applicationGroupAssignment, Collections.emptyMap());
    }

    public ApplicationGroupAssignment assignGroupToApplication(String appId, String groupId, ApplicationGroupAssignment applicationGroupAssignment, Map<String, String> additionalHeaders) throws ApiException {
        ApplicationGroupAssignment localVarPostBody = applicationGroupAssignment;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling assignGroupToApplication");
        }
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling assignGroupToApplication");
        }
        String localVarPath = "/api/v1/apps/{appId}/groups/{groupId}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{groupId\\}", this.apiClient.escapeString(groupId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ApplicationGroupAssignment> localVarReturnType = new TypeReference<ApplicationGroupAssignment>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AppUser assignUserToApplication(String appId, AppUser appUser) throws ApiException {
        return this.assignUserToApplication(appId, appUser, Collections.emptyMap());
    }

    public AppUser assignUserToApplication(String appId, AppUser appUser, Map<String, String> additionalHeaders) throws ApiException {
        AppUser localVarPostBody = appUser;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling assignUserToApplication");
        }
        if (appUser == null) {
            throw new ApiException(400, "Missing the required parameter 'appUser' when calling assignUserToApplication");
        }
        String localVarPath = "/api/v1/apps/{appId}/users".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AppUser> localVarReturnType = new TypeReference<AppUser>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public JsonWebKey cloneApplicationKey(String appId, String keyId, String targetAid) throws ApiException {
        return this.cloneApplicationKey(appId, keyId, targetAid, Collections.emptyMap());
    }

    public JsonWebKey cloneApplicationKey(String appId, String keyId, String targetAid, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling cloneApplicationKey");
        }
        if (keyId == null) {
            throw new ApiException(400, "Missing the required parameter 'keyId' when calling cloneApplicationKey");
        }
        if (targetAid == null) {
            throw new ApiException(400, "Missing the required parameter 'targetAid' when calling cloneApplicationKey");
        }
        String localVarPath = "/api/v1/apps/{appId}/credentials/keys/{keyId}/clone".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{keyId\\}", this.apiClient.escapeString(keyId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("targetAid", targetAid));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<JsonWebKey> localVarReturnType = new TypeReference<JsonWebKey>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Application createApplication(Application application, Boolean activate, String oktaAccessGatewayAgent) throws ApiException {
        return this.createApplication(application, activate, oktaAccessGatewayAgent, Collections.emptyMap());
    }

    public Application createApplication(Application application, Boolean activate, String oktaAccessGatewayAgent, Map<String, String> additionalHeaders) throws ApiException {
        Application localVarPostBody = application;
        if (application == null) {
            throw new ApiException(400, "Missing the required parameter 'application' when calling createApplication");
        }
        String localVarPath = "/api/v1/apps";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("activate", activate));
        if (oktaAccessGatewayAgent != null) {
            localVarHeaderParams.put("OktaAccessGateway-Agent", this.apiClient.parameterToString(oktaAccessGatewayAgent));
        }
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<Application> localVarReturnType = new TypeReference<Application>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deactivateApplication(String appId) throws ApiException {
        this.deactivateApplication(appId, Collections.emptyMap());
    }

    public void deactivateApplication(String appId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling deactivateApplication");
        }
        String localVarPath = "/api/v1/apps/{appId}/lifecycle/deactivate".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deactivateDefaultProvisioningConnectionForApplication(String appId) throws ApiException {
        this.deactivateDefaultProvisioningConnectionForApplication(appId, Collections.emptyMap());
    }

    public void deactivateDefaultProvisioningConnectionForApplication(String appId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling deactivateDefaultProvisioningConnectionForApplication");
        }
        String localVarPath = "/api/v1/apps/{appId}/connections/default/lifecycle/deactivate".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteApplication(String appId) throws ApiException {
        this.deleteApplication(appId, Collections.emptyMap());
    }

    public void deleteApplication(String appId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling deleteApplication");
        }
        String localVarPath = "/api/v1/apps/{appId}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public JsonWebKey generateApplicationKey(String appId, Integer validityYears) throws ApiException {
        return this.generateApplicationKey(appId, validityYears, Collections.emptyMap());
    }

    public JsonWebKey generateApplicationKey(String appId, Integer validityYears, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling generateApplicationKey");
        }
        String localVarPath = "/api/v1/apps/{appId}/credentials/keys/generate".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("validityYears", validityYears));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<JsonWebKey> localVarReturnType = new TypeReference<JsonWebKey>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Csr generateCsrForApplication(String appId, CsrMetadata metadata) throws ApiException {
        return this.generateCsrForApplication(appId, metadata, Collections.emptyMap());
    }

    public Csr generateCsrForApplication(String appId, CsrMetadata metadata, Map<String, String> additionalHeaders) throws ApiException {
        CsrMetadata localVarPostBody = metadata;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling generateCsrForApplication");
        }
        if (metadata == null) {
            throw new ApiException(400, "Missing the required parameter 'metadata' when calling generateCsrForApplication");
        }
        String localVarPath = "/api/v1/apps/{appId}/credentials/csrs".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<Csr> localVarReturnType = new TypeReference<Csr>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Application getApplication(String appId, String expand) throws ApiException {
        return this.getApplication(appId, expand, Collections.emptyMap());
    }

    public Application getApplication(String appId, String expand, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling getApplication");
        }
        String localVarPath = "/api/v1/apps/{appId}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("expand", expand));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<Application> localVarReturnType = new TypeReference<Application>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ApplicationGroupAssignment getApplicationGroupAssignment(String appId, String groupId, String expand) throws ApiException {
        return this.getApplicationGroupAssignment(appId, groupId, expand, Collections.emptyMap());
    }

    public ApplicationGroupAssignment getApplicationGroupAssignment(String appId, String groupId, String expand, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling getApplicationGroupAssignment");
        }
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling getApplicationGroupAssignment");
        }
        String localVarPath = "/api/v1/apps/{appId}/groups/{groupId}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{groupId\\}", this.apiClient.escapeString(groupId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("expand", expand));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ApplicationGroupAssignment> localVarReturnType = new TypeReference<ApplicationGroupAssignment>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public JsonWebKey getApplicationKey(String appId, String keyId) throws ApiException {
        return this.getApplicationKey(appId, keyId, Collections.emptyMap());
    }

    public JsonWebKey getApplicationKey(String appId, String keyId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling getApplicationKey");
        }
        if (keyId == null) {
            throw new ApiException(400, "Missing the required parameter 'keyId' when calling getApplicationKey");
        }
        String localVarPath = "/api/v1/apps/{appId}/credentials/keys/{keyId}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{keyId\\}", this.apiClient.escapeString(keyId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<JsonWebKey> localVarReturnType = new TypeReference<JsonWebKey>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AppUser getApplicationUser(String appId, String userId, String expand) throws ApiException {
        return this.getApplicationUser(appId, userId, expand, Collections.emptyMap());
    }

    public AppUser getApplicationUser(String appId, String userId, String expand, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling getApplicationUser");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling getApplicationUser");
        }
        String localVarPath = "/api/v1/apps/{appId}/users/{userId}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("expand", expand));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AppUser> localVarReturnType = new TypeReference<AppUser>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Csr getCsrForApplication(String appId, String csrId) throws ApiException {
        return this.getCsrForApplication(appId, csrId, Collections.emptyMap());
    }

    public Csr getCsrForApplication(String appId, String csrId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling getCsrForApplication");
        }
        if (csrId == null) {
            throw new ApiException(400, "Missing the required parameter 'csrId' when calling getCsrForApplication");
        }
        String localVarPath = "/api/v1/apps/{appId}/credentials/csrs/{csrId}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{csrId\\}", this.apiClient.escapeString(csrId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<Csr> localVarReturnType = new TypeReference<Csr>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ProvisioningConnection getDefaultProvisioningConnectionForApplication(String appId) throws ApiException {
        return this.getDefaultProvisioningConnectionForApplication(appId, Collections.emptyMap());
    }

    public ProvisioningConnection getDefaultProvisioningConnectionForApplication(String appId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling getDefaultProvisioningConnectionForApplication");
        }
        String localVarPath = "/api/v1/apps/{appId}/connections/default".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ProvisioningConnection> localVarReturnType = new TypeReference<ProvisioningConnection>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ApplicationFeature getFeatureForApplication(String appId, String featureName) throws ApiException {
        return this.getFeatureForApplication(appId, featureName, Collections.emptyMap());
    }

    public ApplicationFeature getFeatureForApplication(String appId, String featureName, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling getFeatureForApplication");
        }
        if (featureName == null) {
            throw new ApiException(400, "Missing the required parameter 'featureName' when calling getFeatureForApplication");
        }
        String localVarPath = "/api/v1/apps/{appId}/features/{featureName}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{featureName\\}", this.apiClient.escapeString(featureName.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ApplicationFeature> localVarReturnType = new TypeReference<ApplicationFeature>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public OAuth2Token getOAuth2TokenForApplication(String appId, String tokenId, String expand) throws ApiException {
        return this.getOAuth2TokenForApplication(appId, tokenId, expand, Collections.emptyMap());
    }

    public OAuth2Token getOAuth2TokenForApplication(String appId, String tokenId, String expand, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling getOAuth2TokenForApplication");
        }
        if (tokenId == null) {
            throw new ApiException(400, "Missing the required parameter 'tokenId' when calling getOAuth2TokenForApplication");
        }
        String localVarPath = "/api/v1/apps/{appId}/tokens/{tokenId}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{tokenId\\}", this.apiClient.escapeString(tokenId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("expand", expand));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<OAuth2Token> localVarReturnType = new TypeReference<OAuth2Token>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public OAuth2ScopeConsentGrant getScopeConsentGrant(String appId, String grantId, String expand) throws ApiException {
        return this.getScopeConsentGrant(appId, grantId, expand, Collections.emptyMap());
    }

    public OAuth2ScopeConsentGrant getScopeConsentGrant(String appId, String grantId, String expand, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling getScopeConsentGrant");
        }
        if (grantId == null) {
            throw new ApiException(400, "Missing the required parameter 'grantId' when calling getScopeConsentGrant");
        }
        String localVarPath = "/api/v1/apps/{appId}/grants/{grantId}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{grantId\\}", this.apiClient.escapeString(grantId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("expand", expand));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<OAuth2ScopeConsentGrant> localVarReturnType = new TypeReference<OAuth2ScopeConsentGrant>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public OAuth2ScopeConsentGrant grantConsentToScope(String appId, OAuth2ScopeConsentGrant oAuth2ScopeConsentGrant) throws ApiException {
        return this.grantConsentToScope(appId, oAuth2ScopeConsentGrant, Collections.emptyMap());
    }

    public OAuth2ScopeConsentGrant grantConsentToScope(String appId, OAuth2ScopeConsentGrant oAuth2ScopeConsentGrant, Map<String, String> additionalHeaders) throws ApiException {
        OAuth2ScopeConsentGrant localVarPostBody = oAuth2ScopeConsentGrant;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling grantConsentToScope");
        }
        if (oAuth2ScopeConsentGrant == null) {
            throw new ApiException(400, "Missing the required parameter 'oAuth2ScopeConsentGrant' when calling grantConsentToScope");
        }
        String localVarPath = "/api/v1/apps/{appId}/grants".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<OAuth2ScopeConsentGrant> localVarReturnType = new TypeReference<OAuth2ScopeConsentGrant>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<ApplicationGroupAssignment> listApplicationGroupAssignments(String appId, String q, String after, Integer limit, String expand) throws ApiException {
        return this.listApplicationGroupAssignments(appId, q, after, limit, expand, Collections.emptyMap());
    }

    public List<ApplicationGroupAssignment> listApplicationGroupAssignments(String appId, String q, String after, Integer limit, String expand, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling listApplicationGroupAssignments");
        }
        String localVarPath = "/api/v1/apps/{appId}/groups".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("q", q));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("expand", expand));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<ApplicationGroupAssignment>> localVarReturnType = new TypeReference<List<ApplicationGroupAssignment>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<JsonWebKey> listApplicationKeys(String appId) throws ApiException {
        return this.listApplicationKeys(appId, Collections.emptyMap());
    }

    public List<JsonWebKey> listApplicationKeys(String appId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling listApplicationKeys");
        }
        String localVarPath = "/api/v1/apps/{appId}/credentials/keys".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<JsonWebKey>> localVarReturnType = new TypeReference<List<JsonWebKey>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<AppUser> listApplicationUsers(String appId, String q, String queryScope, String after, Integer limit, String filter, String expand) throws ApiException {
        return this.listApplicationUsers(appId, q, queryScope, after, limit, filter, expand, Collections.emptyMap());
    }

    public List<AppUser> listApplicationUsers(String appId, String q, String queryScope, String after, Integer limit, String filter, String expand, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling listApplicationUsers");
        }
        String localVarPath = "/api/v1/apps/{appId}/users".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("q", q));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("query_scope", queryScope));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("expand", expand));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<AppUser>> localVarReturnType = new TypeReference<List<AppUser>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<Application> listApplications(String q, String after, Integer limit, String filter, String expand, Boolean includeNonDeleted) throws ApiException {
        return this.listApplications(q, after, limit, filter, expand, includeNonDeleted, Collections.emptyMap());
    }

    public List<Application> listApplications(String q, String after, Integer limit, String filter, String expand, Boolean includeNonDeleted, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/apps";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("q", q));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("expand", expand));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("includeNonDeleted", includeNonDeleted));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<Application>> localVarReturnType = new TypeReference<List<Application>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<Csr> listCsrsForApplication(String appId) throws ApiException {
        return this.listCsrsForApplication(appId, Collections.emptyMap());
    }

    public List<Csr> listCsrsForApplication(String appId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling listCsrsForApplication");
        }
        String localVarPath = "/api/v1/apps/{appId}/credentials/csrs".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<Csr>> localVarReturnType = new TypeReference<List<Csr>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<ApplicationFeature> listFeaturesForApplication(String appId) throws ApiException {
        return this.listFeaturesForApplication(appId, Collections.emptyMap());
    }

    public List<ApplicationFeature> listFeaturesForApplication(String appId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling listFeaturesForApplication");
        }
        String localVarPath = "/api/v1/apps/{appId}/features".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<ApplicationFeature>> localVarReturnType = new TypeReference<List<ApplicationFeature>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<OAuth2Token> listOAuth2TokensForApplication(String appId, String expand, String after, Integer limit) throws ApiException {
        return this.listOAuth2TokensForApplication(appId, expand, after, limit, Collections.emptyMap());
    }

    public List<OAuth2Token> listOAuth2TokensForApplication(String appId, String expand, String after, Integer limit, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling listOAuth2TokensForApplication");
        }
        String localVarPath = "/api/v1/apps/{appId}/tokens".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("expand", expand));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<OAuth2Token>> localVarReturnType = new TypeReference<List<OAuth2Token>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<OAuth2ScopeConsentGrant> listScopeConsentGrants(String appId, String expand) throws ApiException {
        return this.listScopeConsentGrants(appId, expand, Collections.emptyMap());
    }

    public List<OAuth2ScopeConsentGrant> listScopeConsentGrants(String appId, String expand, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling listScopeConsentGrants");
        }
        String localVarPath = "/api/v1/apps/{appId}/grants".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("expand", expand));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<OAuth2ScopeConsentGrant>> localVarReturnType = new TypeReference<List<OAuth2ScopeConsentGrant>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public JsonWebKey publishCsrFromApplication(String appId, String csrId, File body) throws ApiException {
        return this.publishCsrFromApplication(appId, csrId, body, Collections.emptyMap());
    }

    public JsonWebKey publishCsrFromApplication(String appId, String csrId, File body, Map<String, String> additionalHeaders) throws ApiException {
        File localVarPostBody = body;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling publishCsrFromApplication");
        }
        if (csrId == null) {
            throw new ApiException(400, "Missing the required parameter 'csrId' when calling publishCsrFromApplication");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling publishCsrFromApplication");
        }
        String localVarPath = "/api/v1/apps/{appId}/credentials/csrs/{csrId}/lifecycle/publish".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{csrId\\}", this.apiClient.escapeString(csrId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/x-x509-ca-cert", "application/pkix-cert", "application/x-pem-file"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<JsonWebKey> localVarReturnType = new TypeReference<JsonWebKey>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Application replaceApplication(String appId, Application application) throws ApiException {
        return this.replaceApplication(appId, application, Collections.emptyMap());
    }

    public Application replaceApplication(String appId, Application application, Map<String, String> additionalHeaders) throws ApiException {
        Application localVarPostBody = application;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling replaceApplication");
        }
        if (application == null) {
            throw new ApiException(400, "Missing the required parameter 'application' when calling replaceApplication");
        }
        String localVarPath = "/api/v1/apps/{appId}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<Application> localVarReturnType = new TypeReference<Application>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void revokeCsrFromApplication(String appId, String csrId) throws ApiException {
        this.revokeCsrFromApplication(appId, csrId, Collections.emptyMap());
    }

    public void revokeCsrFromApplication(String appId, String csrId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling revokeCsrFromApplication");
        }
        if (csrId == null) {
            throw new ApiException(400, "Missing the required parameter 'csrId' when calling revokeCsrFromApplication");
        }
        String localVarPath = "/api/v1/apps/{appId}/credentials/csrs/{csrId}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{csrId\\}", this.apiClient.escapeString(csrId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void revokeOAuth2TokenForApplication(String appId, String tokenId) throws ApiException {
        this.revokeOAuth2TokenForApplication(appId, tokenId, Collections.emptyMap());
    }

    public void revokeOAuth2TokenForApplication(String appId, String tokenId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling revokeOAuth2TokenForApplication");
        }
        if (tokenId == null) {
            throw new ApiException(400, "Missing the required parameter 'tokenId' when calling revokeOAuth2TokenForApplication");
        }
        String localVarPath = "/api/v1/apps/{appId}/tokens/{tokenId}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{tokenId\\}", this.apiClient.escapeString(tokenId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void revokeOAuth2TokensForApplication(String appId) throws ApiException {
        this.revokeOAuth2TokensForApplication(appId, Collections.emptyMap());
    }

    public void revokeOAuth2TokensForApplication(String appId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling revokeOAuth2TokensForApplication");
        }
        String localVarPath = "/api/v1/apps/{appId}/tokens".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void revokeScopeConsentGrant(String appId, String grantId) throws ApiException {
        this.revokeScopeConsentGrant(appId, grantId, Collections.emptyMap());
    }

    public void revokeScopeConsentGrant(String appId, String grantId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling revokeScopeConsentGrant");
        }
        if (grantId == null) {
            throw new ApiException(400, "Missing the required parameter 'grantId' when calling revokeScopeConsentGrant");
        }
        String localVarPath = "/api/v1/apps/{appId}/grants/{grantId}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{grantId\\}", this.apiClient.escapeString(grantId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void unassignApplicationFromGroup(String appId, String groupId) throws ApiException {
        this.unassignApplicationFromGroup(appId, groupId, Collections.emptyMap());
    }

    public void unassignApplicationFromGroup(String appId, String groupId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling unassignApplicationFromGroup");
        }
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling unassignApplicationFromGroup");
        }
        String localVarPath = "/api/v1/apps/{appId}/groups/{groupId}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{groupId\\}", this.apiClient.escapeString(groupId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void unassignUserFromApplication(String appId, String userId, Boolean sendEmail) throws ApiException {
        this.unassignUserFromApplication(appId, userId, sendEmail, Collections.emptyMap());
    }

    public void unassignUserFromApplication(String appId, String userId, Boolean sendEmail, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling unassignUserFromApplication");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling unassignUserFromApplication");
        }
        String localVarPath = "/api/v1/apps/{appId}/users/{userId}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sendEmail", sendEmail));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public AppUser updateApplicationUser(String appId, String userId, AppUser appUser) throws ApiException {
        return this.updateApplicationUser(appId, userId, appUser, Collections.emptyMap());
    }

    public AppUser updateApplicationUser(String appId, String userId, AppUser appUser, Map<String, String> additionalHeaders) throws ApiException {
        AppUser localVarPostBody = appUser;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling updateApplicationUser");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling updateApplicationUser");
        }
        if (appUser == null) {
            throw new ApiException(400, "Missing the required parameter 'appUser' when calling updateApplicationUser");
        }
        String localVarPath = "/api/v1/apps/{appId}/users/{userId}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AppUser> localVarReturnType = new TypeReference<AppUser>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ProvisioningConnection updateDefaultProvisioningConnectionForApplication(String appId, ProvisioningConnectionRequest provisioningConnectionRequest, Boolean activate) throws ApiException {
        return this.updateDefaultProvisioningConnectionForApplication(appId, provisioningConnectionRequest, activate, Collections.emptyMap());
    }

    public ProvisioningConnection updateDefaultProvisioningConnectionForApplication(String appId, ProvisioningConnectionRequest provisioningConnectionRequest, Boolean activate, Map<String, String> additionalHeaders) throws ApiException {
        ProvisioningConnectionRequest localVarPostBody = provisioningConnectionRequest;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling updateDefaultProvisioningConnectionForApplication");
        }
        if (provisioningConnectionRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'provisioningConnectionRequest' when calling updateDefaultProvisioningConnectionForApplication");
        }
        String localVarPath = "/api/v1/apps/{appId}/connections/default".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("activate", activate));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ProvisioningConnection> localVarReturnType = new TypeReference<ProvisioningConnection>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ApplicationFeature updateFeatureForApplication(String appId, String featureName, CapabilitiesObject capabilitiesObject) throws ApiException {
        return this.updateFeatureForApplication(appId, featureName, capabilitiesObject, Collections.emptyMap());
    }

    public ApplicationFeature updateFeatureForApplication(String appId, String featureName, CapabilitiesObject capabilitiesObject, Map<String, String> additionalHeaders) throws ApiException {
        CapabilitiesObject localVarPostBody = capabilitiesObject;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling updateFeatureForApplication");
        }
        if (featureName == null) {
            throw new ApiException(400, "Missing the required parameter 'featureName' when calling updateFeatureForApplication");
        }
        if (capabilitiesObject == null) {
            throw new ApiException(400, "Missing the required parameter 'capabilitiesObject' when calling updateFeatureForApplication");
        }
        String localVarPath = "/api/v1/apps/{appId}/features/{featureName}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{featureName\\}", this.apiClient.escapeString(featureName.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ApplicationFeature> localVarReturnType = new TypeReference<ApplicationFeature>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void uploadApplicationLogo(String appId, File _file) throws ApiException {
        this.uploadApplicationLogo(appId, _file, Collections.emptyMap());
    }

    public void uploadApplicationLogo(String appId, File _file, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling uploadApplicationLogo");
        }
        if (_file == null) {
            throw new ApiException(400, "Missing the required parameter '_file' when calling uploadApplicationLogo");
        }
        String localVarPath = "/api/v1/apps/{appId}/logo".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        if (_file != null) {
            localVarFormParams.put("file", _file);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

