/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.common.PagedList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.openapitools.client.ApiClient;
import org.openapitools.client.model.SmsTemplate;
import org.openapitools.client.model.SmsTemplateType;
import org.openapitools.jackson.nullable.JsonNullableModule;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

@Component(value="org.openapitools.client.api.TemplateApi")
public class TemplateApi {
    private ApiClient apiClient;

    public TemplateApi() {
        this(new ApiClient());
    }

    @Autowired
    public TemplateApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public SmsTemplate createSmsTemplate(SmsTemplate smsTemplate) throws RestClientException {
        return (SmsTemplate)this.createSmsTemplateWithHttpInfo(smsTemplate).getBody();
    }

    public <T> T createSmsTemplate(Class<?> T, SmsTemplate smsTemplate) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.createSmsTemplateWithReturnType(T, smsTemplate).getBody(), T);
    }

    public ResponseEntity<SmsTemplate> createSmsTemplateWithHttpInfo(SmsTemplate smsTemplate) throws RestClientException {
        SmsTemplate localVarPostBody = smsTemplate;
        if (smsTemplate == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'smsTemplate' when calling createSmsTemplate");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<SmsTemplate> localReturnType = new ParameterizedTypeReference<SmsTemplate>(){};
        return this.apiClient.invokeAPI("/api/v1/templates/sms", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> createSmsTemplateWithReturnType(Class<?> T, SmsTemplate smsTemplate) throws RestClientException {
        SmsTemplate localVarPostBody = smsTemplate;
        if (smsTemplate == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'smsTemplate' when calling createSmsTemplate");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/templates/sms", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList createSmsTemplateWithPaginationInfo(SmsTemplate smsTemplate) throws RestClientException {
        SmsTemplate localVarPostBody = smsTemplate;
        if (smsTemplate == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'smsTemplate' when calling createSmsTemplate");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<SmsTemplate> localReturnType = new ParameterizedTypeReference<SmsTemplate>(){};
        ResponseEntity<SmsTemplate> responseEntity = this.apiClient.invokeAPI("/api/v1/templates/sms", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<SmsTemplate> newResponseEntity = this.apiClient.invokeAPI("/api/v1/templates/sms", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public void deleteSmsTemplate(String templateId) throws RestClientException {
        this.deleteSmsTemplateWithHttpInfo(templateId);
    }

    public ResponseEntity<Void> deleteSmsTemplateWithHttpInfo(String templateId) throws RestClientException {
        Object localVarPostBody = null;
        if (templateId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'templateId' when calling deleteSmsTemplate");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("templateId", templateId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/templates/sms/{templateId}", HttpMethod.DELETE, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public SmsTemplate getSmsTemplate(String templateId) throws RestClientException {
        return (SmsTemplate)this.getSmsTemplateWithHttpInfo(templateId).getBody();
    }

    public ResponseEntity<SmsTemplate> getSmsTemplateWithHttpInfo(String templateId) throws RestClientException {
        Object localVarPostBody = null;
        if (templateId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'templateId' when calling getSmsTemplate");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("templateId", templateId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<SmsTemplate> localReturnType = new ParameterizedTypeReference<SmsTemplate>(){};
        return this.apiClient.invokeAPI("/api/v1/templates/sms/{templateId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList getSmsTemplateWithPaginationInfo(String templateId) throws RestClientException {
        Object localVarPostBody = null;
        if (templateId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'templateId' when calling getSmsTemplate");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("templateId", templateId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<SmsTemplate> localReturnType = new ParameterizedTypeReference<SmsTemplate>(){};
        ResponseEntity<SmsTemplate> responseEntity = this.apiClient.invokeAPI("/api/v1/templates/sms/{templateId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<SmsTemplate> newResponseEntity = this.apiClient.invokeAPI("/api/v1/templates/sms/{templateId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public List<SmsTemplate> listSmsTemplates(SmsTemplateType templateType) throws RestClientException {
        return (List)this.listSmsTemplatesWithHttpInfo(templateType).getBody();
    }

    public ResponseEntity<List<SmsTemplate>> listSmsTemplatesWithHttpInfo(SmsTemplateType templateType) throws RestClientException {
        Object localVarPostBody = null;
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "templateType", (Object)templateType));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<SmsTemplate>> localReturnType = new ParameterizedTypeReference<List<SmsTemplate>>(){};
        return this.apiClient.invokeAPI("/api/v1/templates/sms", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList listSmsTemplatesWithPaginationInfo(SmsTemplateType templateType) throws RestClientException {
        Object localVarPostBody = null;
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "templateType", (Object)templateType));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<SmsTemplate>> localReturnType = new ParameterizedTypeReference<List<SmsTemplate>>(){};
        ResponseEntity<List<SmsTemplate>> responseEntity = this.apiClient.invokeAPI("/api/v1/templates/sms", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<List<SmsTemplate>> newResponseEntity = this.apiClient.invokeAPI("/api/v1/templates/sms", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public SmsTemplate replaceSmsTemplate(String templateId, SmsTemplate smsTemplate) throws RestClientException {
        return (SmsTemplate)this.replaceSmsTemplateWithHttpInfo(templateId, smsTemplate).getBody();
    }

    public <T> T replaceSmsTemplate(Class<?> T, String templateId, SmsTemplate smsTemplate) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.replaceSmsTemplateWithReturnType(T, templateId, smsTemplate).getBody(), T);
    }

    public ResponseEntity<SmsTemplate> replaceSmsTemplateWithHttpInfo(String templateId, SmsTemplate smsTemplate) throws RestClientException {
        SmsTemplate localVarPostBody = smsTemplate;
        if (templateId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'templateId' when calling replaceSmsTemplate");
        }
        if (smsTemplate == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'smsTemplate' when calling replaceSmsTemplate");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("templateId", templateId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<SmsTemplate> localReturnType = new ParameterizedTypeReference<SmsTemplate>(){};
        return this.apiClient.invokeAPI("/api/v1/templates/sms/{templateId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> replaceSmsTemplateWithReturnType(Class<?> T, String templateId, SmsTemplate smsTemplate) throws RestClientException {
        SmsTemplate localVarPostBody = smsTemplate;
        if (templateId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'templateId' when calling replaceSmsTemplate");
        }
        if (smsTemplate == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'smsTemplate' when calling replaceSmsTemplate");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("templateId", templateId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/templates/sms/{templateId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList replaceSmsTemplateWithPaginationInfo(String templateId, SmsTemplate smsTemplate) throws RestClientException {
        SmsTemplate localVarPostBody = smsTemplate;
        if (templateId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'templateId' when calling replaceSmsTemplate");
        }
        if (smsTemplate == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'smsTemplate' when calling replaceSmsTemplate");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("templateId", templateId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<SmsTemplate> localReturnType = new ParameterizedTypeReference<SmsTemplate>(){};
        ResponseEntity<SmsTemplate> responseEntity = this.apiClient.invokeAPI("/api/v1/templates/sms/{templateId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<SmsTemplate> newResponseEntity = this.apiClient.invokeAPI("/api/v1/templates/sms/{templateId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public SmsTemplate updateSmsTemplate(String templateId, SmsTemplate smsTemplate) throws RestClientException {
        return (SmsTemplate)this.updateSmsTemplateWithHttpInfo(templateId, smsTemplate).getBody();
    }

    public <T> T updateSmsTemplate(Class<?> T, String templateId, SmsTemplate smsTemplate) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.updateSmsTemplateWithReturnType(T, templateId, smsTemplate).getBody(), T);
    }

    public ResponseEntity<SmsTemplate> updateSmsTemplateWithHttpInfo(String templateId, SmsTemplate smsTemplate) throws RestClientException {
        SmsTemplate localVarPostBody = smsTemplate;
        if (templateId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'templateId' when calling updateSmsTemplate");
        }
        if (smsTemplate == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'smsTemplate' when calling updateSmsTemplate");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("templateId", templateId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<SmsTemplate> localReturnType = new ParameterizedTypeReference<SmsTemplate>(){};
        return this.apiClient.invokeAPI("/api/v1/templates/sms/{templateId}", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> updateSmsTemplateWithReturnType(Class<?> T, String templateId, SmsTemplate smsTemplate) throws RestClientException {
        SmsTemplate localVarPostBody = smsTemplate;
        if (templateId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'templateId' when calling updateSmsTemplate");
        }
        if (smsTemplate == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'smsTemplate' when calling updateSmsTemplate");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("templateId", templateId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/templates/sms/{templateId}", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList updateSmsTemplateWithPaginationInfo(String templateId, SmsTemplate smsTemplate) throws RestClientException {
        SmsTemplate localVarPostBody = smsTemplate;
        if (templateId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'templateId' when calling updateSmsTemplate");
        }
        if (smsTemplate == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'smsTemplate' when calling updateSmsTemplate");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("templateId", templateId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<SmsTemplate> localReturnType = new ParameterizedTypeReference<SmsTemplate>(){};
        ResponseEntity<SmsTemplate> responseEntity = this.apiClient.invokeAPI("/api/v1/templates/sms/{templateId}", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<SmsTemplate> newResponseEntity = this.apiClient.invokeAPI("/api/v1/templates/sms/{templateId}", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    private ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

