/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.common.PagedList;
import java.util.HashMap;
import java.util.List;
import org.openapitools.client.ApiClient;
import org.openapitools.client.model.CatalogApplication;
import org.openapitools.client.model.Group;
import org.openapitools.jackson.nullable.JsonNullableModule;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

@Component(value="org.openapitools.client.api.RoleTargetApi")
public class RoleTargetApi {
    private ApiClient apiClient;

    public RoleTargetApi() {
        this(new ApiClient());
    }

    @Autowired
    public RoleTargetApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void assignAllAppsAsTargetToRoleForUser(String userId, String roleId) throws RestClientException {
        this.assignAllAppsAsTargetToRoleForUserWithHttpInfo(userId, roleId);
    }

    public ResponseEntity<Void> assignAllAppsAsTargetToRoleForUserWithHttpInfo(String userId, String roleId) throws RestClientException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling assignAllAppsAsTargetToRoleForUser");
        }
        if (roleId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling assignAllAppsAsTargetToRoleForUser");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("userId", userId);
        uriVariables.put("roleId", roleId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/users/{userId}/roles/{roleId}/targets/catalog/apps", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public void assignAppInstanceTargetToAppAdminRoleForGroup(String groupId, String roleId, String appName, String applicationId) throws RestClientException {
        this.assignAppInstanceTargetToAppAdminRoleForGroupWithHttpInfo(groupId, roleId, appName, applicationId);
    }

    public ResponseEntity<Void> assignAppInstanceTargetToAppAdminRoleForGroupWithHttpInfo(String groupId, String roleId, String appName, String applicationId) throws RestClientException {
        Object localVarPostBody = null;
        if (groupId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'groupId' when calling assignAppInstanceTargetToAppAdminRoleForGroup");
        }
        if (roleId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling assignAppInstanceTargetToAppAdminRoleForGroup");
        }
        if (appName == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appName' when calling assignAppInstanceTargetToAppAdminRoleForGroup");
        }
        if (applicationId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'applicationId' when calling assignAppInstanceTargetToAppAdminRoleForGroup");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("groupId", groupId);
        uriVariables.put("roleId", roleId);
        uriVariables.put("appName", appName);
        uriVariables.put("applicationId", applicationId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/groups/{groupId}/roles/{roleId}/targets/catalog/apps/{appName}/{applicationId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public void assignAppInstanceTargetToAppAdminRoleForUser(String userId, String roleId, String appName, String applicationId) throws RestClientException {
        this.assignAppInstanceTargetToAppAdminRoleForUserWithHttpInfo(userId, roleId, appName, applicationId);
    }

    public ResponseEntity<Void> assignAppInstanceTargetToAppAdminRoleForUserWithHttpInfo(String userId, String roleId, String appName, String applicationId) throws RestClientException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling assignAppInstanceTargetToAppAdminRoleForUser");
        }
        if (roleId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling assignAppInstanceTargetToAppAdminRoleForUser");
        }
        if (appName == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appName' when calling assignAppInstanceTargetToAppAdminRoleForUser");
        }
        if (applicationId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'applicationId' when calling assignAppInstanceTargetToAppAdminRoleForUser");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("userId", userId);
        uriVariables.put("roleId", roleId);
        uriVariables.put("appName", appName);
        uriVariables.put("applicationId", applicationId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/users/{userId}/roles/{roleId}/targets/catalog/apps/{appName}/{applicationId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public void assignAppTargetToAdminRoleForGroup(String groupId, String roleId, String appName) throws RestClientException {
        this.assignAppTargetToAdminRoleForGroupWithHttpInfo(groupId, roleId, appName);
    }

    public ResponseEntity<Void> assignAppTargetToAdminRoleForGroupWithHttpInfo(String groupId, String roleId, String appName) throws RestClientException {
        Object localVarPostBody = null;
        if (groupId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'groupId' when calling assignAppTargetToAdminRoleForGroup");
        }
        if (roleId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling assignAppTargetToAdminRoleForGroup");
        }
        if (appName == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appName' when calling assignAppTargetToAdminRoleForGroup");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("groupId", groupId);
        uriVariables.put("roleId", roleId);
        uriVariables.put("appName", appName);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/groups/{groupId}/roles/{roleId}/targets/catalog/apps/{appName}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public void assignAppTargetToAdminRoleForUser(String userId, String roleId, String appName) throws RestClientException {
        this.assignAppTargetToAdminRoleForUserWithHttpInfo(userId, roleId, appName);
    }

    public ResponseEntity<Void> assignAppTargetToAdminRoleForUserWithHttpInfo(String userId, String roleId, String appName) throws RestClientException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling assignAppTargetToAdminRoleForUser");
        }
        if (roleId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling assignAppTargetToAdminRoleForUser");
        }
        if (appName == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appName' when calling assignAppTargetToAdminRoleForUser");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("userId", userId);
        uriVariables.put("roleId", roleId);
        uriVariables.put("appName", appName);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/users/{userId}/roles/{roleId}/targets/catalog/apps/{appName}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public void assignGroupTargetToGroupAdminRole(String groupId, String roleId, String targetGroupId) throws RestClientException {
        this.assignGroupTargetToGroupAdminRoleWithHttpInfo(groupId, roleId, targetGroupId);
    }

    public ResponseEntity<Void> assignGroupTargetToGroupAdminRoleWithHttpInfo(String groupId, String roleId, String targetGroupId) throws RestClientException {
        Object localVarPostBody = null;
        if (groupId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'groupId' when calling assignGroupTargetToGroupAdminRole");
        }
        if (roleId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling assignGroupTargetToGroupAdminRole");
        }
        if (targetGroupId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'targetGroupId' when calling assignGroupTargetToGroupAdminRole");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("groupId", groupId);
        uriVariables.put("roleId", roleId);
        uriVariables.put("targetGroupId", targetGroupId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/groups/{groupId}/roles/{roleId}/targets/groups/{targetGroupId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public void assignGroupTargetToUserRole(String userId, String roleId, String groupId) throws RestClientException {
        this.assignGroupTargetToUserRoleWithHttpInfo(userId, roleId, groupId);
    }

    public ResponseEntity<Void> assignGroupTargetToUserRoleWithHttpInfo(String userId, String roleId, String groupId) throws RestClientException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling assignGroupTargetToUserRole");
        }
        if (roleId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling assignGroupTargetToUserRole");
        }
        if (groupId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'groupId' when calling assignGroupTargetToUserRole");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("userId", userId);
        uriVariables.put("roleId", roleId);
        uriVariables.put("groupId", groupId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/users/{userId}/roles/{roleId}/targets/groups/{groupId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public List<CatalogApplication> listApplicationTargetsForApplicationAdministratorRoleForGroup(String groupId, String roleId, String after, Integer limit) throws RestClientException {
        return (List)this.listApplicationTargetsForApplicationAdministratorRoleForGroupWithHttpInfo(groupId, roleId, after, limit).getBody();
    }

    public ResponseEntity<List<CatalogApplication>> listApplicationTargetsForApplicationAdministratorRoleForGroupWithHttpInfo(String groupId, String roleId, String after, Integer limit) throws RestClientException {
        Object localVarPostBody = null;
        if (groupId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'groupId' when calling listApplicationTargetsForApplicationAdministratorRoleForGroup");
        }
        if (roleId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling listApplicationTargetsForApplicationAdministratorRoleForGroup");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("groupId", groupId);
        uriVariables.put("roleId", roleId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", after));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "limit", limit));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<CatalogApplication>> localReturnType = new ParameterizedTypeReference<List<CatalogApplication>>(){};
        return this.apiClient.invokeAPI("/api/v1/groups/{groupId}/roles/{roleId}/targets/catalog/apps", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList listApplicationTargetsForApplicationAdministratorRoleForGroupWithPaginationInfo(String groupId, String roleId, String after, Integer limit) throws RestClientException {
        Object localVarPostBody = null;
        if (groupId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'groupId' when calling listApplicationTargetsForApplicationAdministratorRoleForGroup");
        }
        if (roleId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling listApplicationTargetsForApplicationAdministratorRoleForGroup");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("groupId", groupId);
        uriVariables.put("roleId", roleId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", after));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "limit", limit));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<CatalogApplication>> localReturnType = new ParameterizedTypeReference<List<CatalogApplication>>(){};
        ResponseEntity<List<CatalogApplication>> responseEntity = this.apiClient.invokeAPI("/api/v1/groups/{groupId}/roles/{roleId}/targets/catalog/apps", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<List<CatalogApplication>> newResponseEntity = this.apiClient.invokeAPI("/api/v1/groups/{groupId}/roles/{roleId}/targets/catalog/apps", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public List<CatalogApplication> listApplicationTargetsForApplicationAdministratorRoleForUser(String userId, String roleId, String after, Integer limit) throws RestClientException {
        return (List)this.listApplicationTargetsForApplicationAdministratorRoleForUserWithHttpInfo(userId, roleId, after, limit).getBody();
    }

    public ResponseEntity<List<CatalogApplication>> listApplicationTargetsForApplicationAdministratorRoleForUserWithHttpInfo(String userId, String roleId, String after, Integer limit) throws RestClientException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling listApplicationTargetsForApplicationAdministratorRoleForUser");
        }
        if (roleId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling listApplicationTargetsForApplicationAdministratorRoleForUser");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("userId", userId);
        uriVariables.put("roleId", roleId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", after));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "limit", limit));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<CatalogApplication>> localReturnType = new ParameterizedTypeReference<List<CatalogApplication>>(){};
        return this.apiClient.invokeAPI("/api/v1/users/{userId}/roles/{roleId}/targets/catalog/apps", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList listApplicationTargetsForApplicationAdministratorRoleForUserWithPaginationInfo(String userId, String roleId, String after, Integer limit) throws RestClientException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling listApplicationTargetsForApplicationAdministratorRoleForUser");
        }
        if (roleId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling listApplicationTargetsForApplicationAdministratorRoleForUser");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("userId", userId);
        uriVariables.put("roleId", roleId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", after));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "limit", limit));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<CatalogApplication>> localReturnType = new ParameterizedTypeReference<List<CatalogApplication>>(){};
        ResponseEntity<List<CatalogApplication>> responseEntity = this.apiClient.invokeAPI("/api/v1/users/{userId}/roles/{roleId}/targets/catalog/apps", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<List<CatalogApplication>> newResponseEntity = this.apiClient.invokeAPI("/api/v1/users/{userId}/roles/{roleId}/targets/catalog/apps", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public List<Group> listGroupTargetsForGroupRole(String groupId, String roleId, String after, Integer limit) throws RestClientException {
        return (List)this.listGroupTargetsForGroupRoleWithHttpInfo(groupId, roleId, after, limit).getBody();
    }

    public ResponseEntity<List<Group>> listGroupTargetsForGroupRoleWithHttpInfo(String groupId, String roleId, String after, Integer limit) throws RestClientException {
        Object localVarPostBody = null;
        if (groupId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'groupId' when calling listGroupTargetsForGroupRole");
        }
        if (roleId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling listGroupTargetsForGroupRole");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("groupId", groupId);
        uriVariables.put("roleId", roleId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", after));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "limit", limit));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<Group>> localReturnType = new ParameterizedTypeReference<List<Group>>(){};
        return this.apiClient.invokeAPI("/api/v1/groups/{groupId}/roles/{roleId}/targets/groups", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList listGroupTargetsForGroupRoleWithPaginationInfo(String groupId, String roleId, String after, Integer limit) throws RestClientException {
        Object localVarPostBody = null;
        if (groupId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'groupId' when calling listGroupTargetsForGroupRole");
        }
        if (roleId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling listGroupTargetsForGroupRole");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("groupId", groupId);
        uriVariables.put("roleId", roleId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", after));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "limit", limit));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<Group>> localReturnType = new ParameterizedTypeReference<List<Group>>(){};
        ResponseEntity<List<Group>> responseEntity = this.apiClient.invokeAPI("/api/v1/groups/{groupId}/roles/{roleId}/targets/groups", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<List<Group>> newResponseEntity = this.apiClient.invokeAPI("/api/v1/groups/{groupId}/roles/{roleId}/targets/groups", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public List<Group> listGroupTargetsForRole(String userId, String roleId, String after, Integer limit) throws RestClientException {
        return (List)this.listGroupTargetsForRoleWithHttpInfo(userId, roleId, after, limit).getBody();
    }

    public ResponseEntity<List<Group>> listGroupTargetsForRoleWithHttpInfo(String userId, String roleId, String after, Integer limit) throws RestClientException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling listGroupTargetsForRole");
        }
        if (roleId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling listGroupTargetsForRole");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("userId", userId);
        uriVariables.put("roleId", roleId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", after));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "limit", limit));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<Group>> localReturnType = new ParameterizedTypeReference<List<Group>>(){};
        return this.apiClient.invokeAPI("/api/v1/users/{userId}/roles/{roleId}/targets/groups", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList listGroupTargetsForRoleWithPaginationInfo(String userId, String roleId, String after, Integer limit) throws RestClientException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling listGroupTargetsForRole");
        }
        if (roleId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling listGroupTargetsForRole");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("userId", userId);
        uriVariables.put("roleId", roleId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", after));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "limit", limit));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<Group>> localReturnType = new ParameterizedTypeReference<List<Group>>(){};
        ResponseEntity<List<Group>> responseEntity = this.apiClient.invokeAPI("/api/v1/users/{userId}/roles/{roleId}/targets/groups", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<List<Group>> newResponseEntity = this.apiClient.invokeAPI("/api/v1/users/{userId}/roles/{roleId}/targets/groups", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public void unassignAppInstanceTargetFromAdminRoleForUser(String userId, String roleId, String appName, String applicationId) throws RestClientException {
        this.unassignAppInstanceTargetFromAdminRoleForUserWithHttpInfo(userId, roleId, appName, applicationId);
    }

    public ResponseEntity<Void> unassignAppInstanceTargetFromAdminRoleForUserWithHttpInfo(String userId, String roleId, String appName, String applicationId) throws RestClientException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling unassignAppInstanceTargetFromAdminRoleForUser");
        }
        if (roleId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling unassignAppInstanceTargetFromAdminRoleForUser");
        }
        if (appName == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appName' when calling unassignAppInstanceTargetFromAdminRoleForUser");
        }
        if (applicationId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'applicationId' when calling unassignAppInstanceTargetFromAdminRoleForUser");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("userId", userId);
        uriVariables.put("roleId", roleId);
        uriVariables.put("appName", appName);
        uriVariables.put("applicationId", applicationId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/users/{userId}/roles/{roleId}/targets/catalog/apps/{appName}/{applicationId}", HttpMethod.DELETE, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public void unassignAppInstanceTargetToAppAdminRoleForGroup(String groupId, String roleId, String appName, String applicationId) throws RestClientException {
        this.unassignAppInstanceTargetToAppAdminRoleForGroupWithHttpInfo(groupId, roleId, appName, applicationId);
    }

    public ResponseEntity<Void> unassignAppInstanceTargetToAppAdminRoleForGroupWithHttpInfo(String groupId, String roleId, String appName, String applicationId) throws RestClientException {
        Object localVarPostBody = null;
        if (groupId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'groupId' when calling unassignAppInstanceTargetToAppAdminRoleForGroup");
        }
        if (roleId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling unassignAppInstanceTargetToAppAdminRoleForGroup");
        }
        if (appName == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appName' when calling unassignAppInstanceTargetToAppAdminRoleForGroup");
        }
        if (applicationId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'applicationId' when calling unassignAppInstanceTargetToAppAdminRoleForGroup");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("groupId", groupId);
        uriVariables.put("roleId", roleId);
        uriVariables.put("appName", appName);
        uriVariables.put("applicationId", applicationId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/groups/{groupId}/roles/{roleId}/targets/catalog/apps/{appName}/{applicationId}", HttpMethod.DELETE, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public void unassignAppTargetFromAppAdminRoleForUser(String userId, String roleId, String appName) throws RestClientException {
        this.unassignAppTargetFromAppAdminRoleForUserWithHttpInfo(userId, roleId, appName);
    }

    public ResponseEntity<Void> unassignAppTargetFromAppAdminRoleForUserWithHttpInfo(String userId, String roleId, String appName) throws RestClientException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling unassignAppTargetFromAppAdminRoleForUser");
        }
        if (roleId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling unassignAppTargetFromAppAdminRoleForUser");
        }
        if (appName == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appName' when calling unassignAppTargetFromAppAdminRoleForUser");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("userId", userId);
        uriVariables.put("roleId", roleId);
        uriVariables.put("appName", appName);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/users/{userId}/roles/{roleId}/targets/catalog/apps/{appName}", HttpMethod.DELETE, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public void unassignAppTargetToAdminRoleForGroup(String groupId, String roleId, String appName) throws RestClientException {
        this.unassignAppTargetToAdminRoleForGroupWithHttpInfo(groupId, roleId, appName);
    }

    public ResponseEntity<Void> unassignAppTargetToAdminRoleForGroupWithHttpInfo(String groupId, String roleId, String appName) throws RestClientException {
        Object localVarPostBody = null;
        if (groupId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'groupId' when calling unassignAppTargetToAdminRoleForGroup");
        }
        if (roleId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling unassignAppTargetToAdminRoleForGroup");
        }
        if (appName == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appName' when calling unassignAppTargetToAdminRoleForGroup");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("groupId", groupId);
        uriVariables.put("roleId", roleId);
        uriVariables.put("appName", appName);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/groups/{groupId}/roles/{roleId}/targets/catalog/apps/{appName}", HttpMethod.DELETE, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public void unassignGroupTargetFromGroupAdminRole(String groupId, String roleId, String targetGroupId) throws RestClientException {
        this.unassignGroupTargetFromGroupAdminRoleWithHttpInfo(groupId, roleId, targetGroupId);
    }

    public ResponseEntity<Void> unassignGroupTargetFromGroupAdminRoleWithHttpInfo(String groupId, String roleId, String targetGroupId) throws RestClientException {
        Object localVarPostBody = null;
        if (groupId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'groupId' when calling unassignGroupTargetFromGroupAdminRole");
        }
        if (roleId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling unassignGroupTargetFromGroupAdminRole");
        }
        if (targetGroupId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'targetGroupId' when calling unassignGroupTargetFromGroupAdminRole");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("groupId", groupId);
        uriVariables.put("roleId", roleId);
        uriVariables.put("targetGroupId", targetGroupId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/groups/{groupId}/roles/{roleId}/targets/groups/{targetGroupId}", HttpMethod.DELETE, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public void unassignGroupTargetFromUserAdminRole(String userId, String roleId, String groupId) throws RestClientException {
        this.unassignGroupTargetFromUserAdminRoleWithHttpInfo(userId, roleId, groupId);
    }

    public ResponseEntity<Void> unassignGroupTargetFromUserAdminRoleWithHttpInfo(String userId, String roleId, String groupId) throws RestClientException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling unassignGroupTargetFromUserAdminRole");
        }
        if (roleId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling unassignGroupTargetFromUserAdminRole");
        }
        if (groupId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'groupId' when calling unassignGroupTargetFromUserAdminRole");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("userId", userId);
        uriVariables.put("roleId", roleId);
        uriVariables.put("groupId", groupId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/users/{userId}/roles/{roleId}/targets/groups/{groupId}", HttpMethod.DELETE, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

