/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.common.PagedList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.openapitools.client.ApiClient;
import org.openapitools.client.model.ResourceSet;
import org.openapitools.client.model.ResourceSetBindingAddMembersRequest;
import org.openapitools.client.model.ResourceSetBindingCreateRequest;
import org.openapitools.client.model.ResourceSetBindingMember;
import org.openapitools.client.model.ResourceSetBindingMembers;
import org.openapitools.client.model.ResourceSetBindingResponse;
import org.openapitools.client.model.ResourceSetBindings;
import org.openapitools.client.model.ResourceSetResourcePatchRequest;
import org.openapitools.client.model.ResourceSetResources;
import org.openapitools.client.model.ResourceSets;
import org.openapitools.jackson.nullable.JsonNullableModule;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

@Component(value="org.openapitools.client.api.ResourceSetApi")
public class ResourceSetApi {
    private ApiClient apiClient;

    public ResourceSetApi() {
        this(new ApiClient());
    }

    @Autowired
    public ResourceSetApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ResourceSetBindingResponse addMembersToBinding(String resourceSetId, String roleIdOrLabel, ResourceSetBindingAddMembersRequest instance) throws RestClientException {
        return (ResourceSetBindingResponse)this.addMembersToBindingWithHttpInfo(resourceSetId, roleIdOrLabel, instance).getBody();
    }

    public <T> T addMembersToBinding(Class<?> T, String resourceSetId, String roleIdOrLabel, ResourceSetBindingAddMembersRequest instance) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.addMembersToBindingWithReturnType(T, resourceSetId, roleIdOrLabel, instance).getBody(), T);
    }

    public ResponseEntity<ResourceSetBindingResponse> addMembersToBindingWithHttpInfo(String resourceSetId, String roleIdOrLabel, ResourceSetBindingAddMembersRequest instance) throws RestClientException {
        ResourceSetBindingAddMembersRequest localVarPostBody = instance;
        if (resourceSetId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling addMembersToBinding");
        }
        if (roleIdOrLabel == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleIdOrLabel' when calling addMembersToBinding");
        }
        if (instance == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling addMembersToBinding");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("resourceSetId", resourceSetId);
        uriVariables.put("roleIdOrLabel", roleIdOrLabel);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<ResourceSetBindingResponse> localReturnType = new ParameterizedTypeReference<ResourceSetBindingResponse>(){};
        return this.apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/bindings/{roleIdOrLabel}/members", HttpMethod.PATCH, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> addMembersToBindingWithReturnType(Class<?> T, String resourceSetId, String roleIdOrLabel, ResourceSetBindingAddMembersRequest instance) throws RestClientException {
        ResourceSetBindingAddMembersRequest localVarPostBody = instance;
        if (resourceSetId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling addMembersToBinding");
        }
        if (roleIdOrLabel == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleIdOrLabel' when calling addMembersToBinding");
        }
        if (instance == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling addMembersToBinding");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("resourceSetId", resourceSetId);
        uriVariables.put("roleIdOrLabel", roleIdOrLabel);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/bindings/{roleIdOrLabel}/members", HttpMethod.PATCH, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList addMembersToBindingWithPaginationInfo(String resourceSetId, String roleIdOrLabel, ResourceSetBindingAddMembersRequest instance) throws RestClientException {
        ResourceSetBindingAddMembersRequest localVarPostBody = instance;
        if (resourceSetId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling addMembersToBinding");
        }
        if (roleIdOrLabel == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleIdOrLabel' when calling addMembersToBinding");
        }
        if (instance == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling addMembersToBinding");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("resourceSetId", resourceSetId);
        uriVariables.put("roleIdOrLabel", roleIdOrLabel);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<ResourceSetBindingResponse> localReturnType = new ParameterizedTypeReference<ResourceSetBindingResponse>(){};
        ResponseEntity<ResourceSetBindingResponse> responseEntity = this.apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/bindings/{roleIdOrLabel}/members", HttpMethod.PATCH, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<ResourceSetBindingResponse> newResponseEntity = this.apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/bindings/{roleIdOrLabel}/members", HttpMethod.PATCH, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public ResourceSet addResourceSetResource(String resourceSetId, ResourceSetResourcePatchRequest instance) throws RestClientException {
        return (ResourceSet)this.addResourceSetResourceWithHttpInfo(resourceSetId, instance).getBody();
    }

    public <T> T addResourceSetResource(Class<?> T, String resourceSetId, ResourceSetResourcePatchRequest instance) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.addResourceSetResourceWithReturnType(T, resourceSetId, instance).getBody(), T);
    }

    public ResponseEntity<ResourceSet> addResourceSetResourceWithHttpInfo(String resourceSetId, ResourceSetResourcePatchRequest instance) throws RestClientException {
        ResourceSetResourcePatchRequest localVarPostBody = instance;
        if (resourceSetId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling addResourceSetResource");
        }
        if (instance == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling addResourceSetResource");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("resourceSetId", resourceSetId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<ResourceSet> localReturnType = new ParameterizedTypeReference<ResourceSet>(){};
        return this.apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/resources", HttpMethod.PATCH, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> addResourceSetResourceWithReturnType(Class<?> T, String resourceSetId, ResourceSetResourcePatchRequest instance) throws RestClientException {
        ResourceSetResourcePatchRequest localVarPostBody = instance;
        if (resourceSetId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling addResourceSetResource");
        }
        if (instance == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling addResourceSetResource");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("resourceSetId", resourceSetId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/resources", HttpMethod.PATCH, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList addResourceSetResourceWithPaginationInfo(String resourceSetId, ResourceSetResourcePatchRequest instance) throws RestClientException {
        ResourceSetResourcePatchRequest localVarPostBody = instance;
        if (resourceSetId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling addResourceSetResource");
        }
        if (instance == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling addResourceSetResource");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("resourceSetId", resourceSetId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<ResourceSet> localReturnType = new ParameterizedTypeReference<ResourceSet>(){};
        ResponseEntity<ResourceSet> responseEntity = this.apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/resources", HttpMethod.PATCH, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<ResourceSet> newResponseEntity = this.apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/resources", HttpMethod.PATCH, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public ResourceSet createResourceSet(ResourceSet instance) throws RestClientException {
        return (ResourceSet)this.createResourceSetWithHttpInfo(instance).getBody();
    }

    public <T> T createResourceSet(Class<?> T, ResourceSet instance) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.createResourceSetWithReturnType(T, instance).getBody(), T);
    }

    public ResponseEntity<ResourceSet> createResourceSetWithHttpInfo(ResourceSet instance) throws RestClientException {
        ResourceSet localVarPostBody = instance;
        if (instance == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling createResourceSet");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<ResourceSet> localReturnType = new ParameterizedTypeReference<ResourceSet>(){};
        return this.apiClient.invokeAPI("/api/v1/iam/resource-sets", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> createResourceSetWithReturnType(Class<?> T, ResourceSet instance) throws RestClientException {
        ResourceSet localVarPostBody = instance;
        if (instance == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling createResourceSet");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/iam/resource-sets", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList createResourceSetWithPaginationInfo(ResourceSet instance) throws RestClientException {
        ResourceSet localVarPostBody = instance;
        if (instance == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling createResourceSet");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<ResourceSet> localReturnType = new ParameterizedTypeReference<ResourceSet>(){};
        ResponseEntity<ResourceSet> responseEntity = this.apiClient.invokeAPI("/api/v1/iam/resource-sets", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<ResourceSet> newResponseEntity = this.apiClient.invokeAPI("/api/v1/iam/resource-sets", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public ResourceSetBindingResponse createResourceSetBinding(String resourceSetId, ResourceSetBindingCreateRequest instance) throws RestClientException {
        return (ResourceSetBindingResponse)this.createResourceSetBindingWithHttpInfo(resourceSetId, instance).getBody();
    }

    public <T> T createResourceSetBinding(Class<?> T, String resourceSetId, ResourceSetBindingCreateRequest instance) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.createResourceSetBindingWithReturnType(T, resourceSetId, instance).getBody(), T);
    }

    public ResponseEntity<ResourceSetBindingResponse> createResourceSetBindingWithHttpInfo(String resourceSetId, ResourceSetBindingCreateRequest instance) throws RestClientException {
        ResourceSetBindingCreateRequest localVarPostBody = instance;
        if (resourceSetId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling createResourceSetBinding");
        }
        if (instance == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling createResourceSetBinding");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("resourceSetId", resourceSetId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<ResourceSetBindingResponse> localReturnType = new ParameterizedTypeReference<ResourceSetBindingResponse>(){};
        return this.apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/bindings", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> createResourceSetBindingWithReturnType(Class<?> T, String resourceSetId, ResourceSetBindingCreateRequest instance) throws RestClientException {
        ResourceSetBindingCreateRequest localVarPostBody = instance;
        if (resourceSetId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling createResourceSetBinding");
        }
        if (instance == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling createResourceSetBinding");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("resourceSetId", resourceSetId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/bindings", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList createResourceSetBindingWithPaginationInfo(String resourceSetId, ResourceSetBindingCreateRequest instance) throws RestClientException {
        ResourceSetBindingCreateRequest localVarPostBody = instance;
        if (resourceSetId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling createResourceSetBinding");
        }
        if (instance == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling createResourceSetBinding");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("resourceSetId", resourceSetId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<ResourceSetBindingResponse> localReturnType = new ParameterizedTypeReference<ResourceSetBindingResponse>(){};
        ResponseEntity<ResourceSetBindingResponse> responseEntity = this.apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/bindings", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<ResourceSetBindingResponse> newResponseEntity = this.apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/bindings", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public void deleteBinding(String resourceSetId, String roleIdOrLabel) throws RestClientException {
        this.deleteBindingWithHttpInfo(resourceSetId, roleIdOrLabel);
    }

    public ResponseEntity<Void> deleteBindingWithHttpInfo(String resourceSetId, String roleIdOrLabel) throws RestClientException {
        Object localVarPostBody = null;
        if (resourceSetId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling deleteBinding");
        }
        if (roleIdOrLabel == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleIdOrLabel' when calling deleteBinding");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("resourceSetId", resourceSetId);
        uriVariables.put("roleIdOrLabel", roleIdOrLabel);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/bindings/{roleIdOrLabel}", HttpMethod.DELETE, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public void deleteResourceSet(String resourceSetId) throws RestClientException {
        this.deleteResourceSetWithHttpInfo(resourceSetId);
    }

    public ResponseEntity<Void> deleteResourceSetWithHttpInfo(String resourceSetId) throws RestClientException {
        Object localVarPostBody = null;
        if (resourceSetId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling deleteResourceSet");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("resourceSetId", resourceSetId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}", HttpMethod.DELETE, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public void deleteResourceSetResource(String resourceSetId, String resourceId) throws RestClientException {
        this.deleteResourceSetResourceWithHttpInfo(resourceSetId, resourceId);
    }

    public ResponseEntity<Void> deleteResourceSetResourceWithHttpInfo(String resourceSetId, String resourceId) throws RestClientException {
        Object localVarPostBody = null;
        if (resourceSetId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling deleteResourceSetResource");
        }
        if (resourceId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceId' when calling deleteResourceSetResource");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("resourceSetId", resourceSetId);
        uriVariables.put("resourceId", resourceId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/resources/{resourceId}", HttpMethod.DELETE, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public ResourceSetBindingResponse getBinding(String resourceSetId, String roleIdOrLabel) throws RestClientException {
        return (ResourceSetBindingResponse)this.getBindingWithHttpInfo(resourceSetId, roleIdOrLabel).getBody();
    }

    public ResponseEntity<ResourceSetBindingResponse> getBindingWithHttpInfo(String resourceSetId, String roleIdOrLabel) throws RestClientException {
        Object localVarPostBody = null;
        if (resourceSetId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling getBinding");
        }
        if (roleIdOrLabel == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleIdOrLabel' when calling getBinding");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("resourceSetId", resourceSetId);
        uriVariables.put("roleIdOrLabel", roleIdOrLabel);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<ResourceSetBindingResponse> localReturnType = new ParameterizedTypeReference<ResourceSetBindingResponse>(){};
        return this.apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/bindings/{roleIdOrLabel}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList getBindingWithPaginationInfo(String resourceSetId, String roleIdOrLabel) throws RestClientException {
        Object localVarPostBody = null;
        if (resourceSetId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling getBinding");
        }
        if (roleIdOrLabel == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleIdOrLabel' when calling getBinding");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("resourceSetId", resourceSetId);
        uriVariables.put("roleIdOrLabel", roleIdOrLabel);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<ResourceSetBindingResponse> localReturnType = new ParameterizedTypeReference<ResourceSetBindingResponse>(){};
        ResponseEntity<ResourceSetBindingResponse> responseEntity = this.apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/bindings/{roleIdOrLabel}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<ResourceSetBindingResponse> newResponseEntity = this.apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/bindings/{roleIdOrLabel}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public ResourceSetBindingMember getMemberOfBinding(String resourceSetId, String roleIdOrLabel, String memberId) throws RestClientException {
        return (ResourceSetBindingMember)this.getMemberOfBindingWithHttpInfo(resourceSetId, roleIdOrLabel, memberId).getBody();
    }

    public ResponseEntity<ResourceSetBindingMember> getMemberOfBindingWithHttpInfo(String resourceSetId, String roleIdOrLabel, String memberId) throws RestClientException {
        Object localVarPostBody = null;
        if (resourceSetId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling getMemberOfBinding");
        }
        if (roleIdOrLabel == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleIdOrLabel' when calling getMemberOfBinding");
        }
        if (memberId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'memberId' when calling getMemberOfBinding");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("resourceSetId", resourceSetId);
        uriVariables.put("roleIdOrLabel", roleIdOrLabel);
        uriVariables.put("memberId", memberId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<ResourceSetBindingMember> localReturnType = new ParameterizedTypeReference<ResourceSetBindingMember>(){};
        return this.apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/bindings/{roleIdOrLabel}/members/{memberId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList getMemberOfBindingWithPaginationInfo(String resourceSetId, String roleIdOrLabel, String memberId) throws RestClientException {
        Object localVarPostBody = null;
        if (resourceSetId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling getMemberOfBinding");
        }
        if (roleIdOrLabel == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleIdOrLabel' when calling getMemberOfBinding");
        }
        if (memberId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'memberId' when calling getMemberOfBinding");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("resourceSetId", resourceSetId);
        uriVariables.put("roleIdOrLabel", roleIdOrLabel);
        uriVariables.put("memberId", memberId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<ResourceSetBindingMember> localReturnType = new ParameterizedTypeReference<ResourceSetBindingMember>(){};
        ResponseEntity<ResourceSetBindingMember> responseEntity = this.apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/bindings/{roleIdOrLabel}/members/{memberId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<ResourceSetBindingMember> newResponseEntity = this.apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/bindings/{roleIdOrLabel}/members/{memberId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public ResourceSet getResourceSet(String resourceSetId) throws RestClientException {
        return (ResourceSet)this.getResourceSetWithHttpInfo(resourceSetId).getBody();
    }

    public ResponseEntity<ResourceSet> getResourceSetWithHttpInfo(String resourceSetId) throws RestClientException {
        Object localVarPostBody = null;
        if (resourceSetId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling getResourceSet");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("resourceSetId", resourceSetId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<ResourceSet> localReturnType = new ParameterizedTypeReference<ResourceSet>(){};
        return this.apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList getResourceSetWithPaginationInfo(String resourceSetId) throws RestClientException {
        Object localVarPostBody = null;
        if (resourceSetId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling getResourceSet");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("resourceSetId", resourceSetId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<ResourceSet> localReturnType = new ParameterizedTypeReference<ResourceSet>(){};
        ResponseEntity<ResourceSet> responseEntity = this.apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<ResourceSet> newResponseEntity = this.apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public ResourceSetBindings listBindings(String resourceSetId, String after) throws RestClientException {
        return (ResourceSetBindings)this.listBindingsWithHttpInfo(resourceSetId, after).getBody();
    }

    public ResponseEntity<ResourceSetBindings> listBindingsWithHttpInfo(String resourceSetId, String after) throws RestClientException {
        Object localVarPostBody = null;
        if (resourceSetId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling listBindings");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("resourceSetId", resourceSetId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", after));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<ResourceSetBindings> localReturnType = new ParameterizedTypeReference<ResourceSetBindings>(){};
        return this.apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/bindings", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList listBindingsWithPaginationInfo(String resourceSetId, String after) throws RestClientException {
        Object localVarPostBody = null;
        if (resourceSetId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling listBindings");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("resourceSetId", resourceSetId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", after));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<ResourceSetBindings> localReturnType = new ParameterizedTypeReference<ResourceSetBindings>(){};
        ResponseEntity<ResourceSetBindings> responseEntity = this.apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/bindings", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<ResourceSetBindings> newResponseEntity = this.apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/bindings", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public ResourceSetBindingMembers listMembersOfBinding(String resourceSetId, String roleIdOrLabel, String after) throws RestClientException {
        return (ResourceSetBindingMembers)this.listMembersOfBindingWithHttpInfo(resourceSetId, roleIdOrLabel, after).getBody();
    }

    public ResponseEntity<ResourceSetBindingMembers> listMembersOfBindingWithHttpInfo(String resourceSetId, String roleIdOrLabel, String after) throws RestClientException {
        Object localVarPostBody = null;
        if (resourceSetId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling listMembersOfBinding");
        }
        if (roleIdOrLabel == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleIdOrLabel' when calling listMembersOfBinding");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("resourceSetId", resourceSetId);
        uriVariables.put("roleIdOrLabel", roleIdOrLabel);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", after));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<ResourceSetBindingMembers> localReturnType = new ParameterizedTypeReference<ResourceSetBindingMembers>(){};
        return this.apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/bindings/{roleIdOrLabel}/members", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList listMembersOfBindingWithPaginationInfo(String resourceSetId, String roleIdOrLabel, String after) throws RestClientException {
        Object localVarPostBody = null;
        if (resourceSetId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling listMembersOfBinding");
        }
        if (roleIdOrLabel == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleIdOrLabel' when calling listMembersOfBinding");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("resourceSetId", resourceSetId);
        uriVariables.put("roleIdOrLabel", roleIdOrLabel);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", after));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<ResourceSetBindingMembers> localReturnType = new ParameterizedTypeReference<ResourceSetBindingMembers>(){};
        ResponseEntity<ResourceSetBindingMembers> responseEntity = this.apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/bindings/{roleIdOrLabel}/members", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<ResourceSetBindingMembers> newResponseEntity = this.apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/bindings/{roleIdOrLabel}/members", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public ResourceSetResources listResourceSetResources(String resourceSetId) throws RestClientException {
        return (ResourceSetResources)this.listResourceSetResourcesWithHttpInfo(resourceSetId).getBody();
    }

    public ResponseEntity<ResourceSetResources> listResourceSetResourcesWithHttpInfo(String resourceSetId) throws RestClientException {
        Object localVarPostBody = null;
        if (resourceSetId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling listResourceSetResources");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("resourceSetId", resourceSetId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<ResourceSetResources> localReturnType = new ParameterizedTypeReference<ResourceSetResources>(){};
        return this.apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/resources", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList listResourceSetResourcesWithPaginationInfo(String resourceSetId) throws RestClientException {
        Object localVarPostBody = null;
        if (resourceSetId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling listResourceSetResources");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("resourceSetId", resourceSetId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<ResourceSetResources> localReturnType = new ParameterizedTypeReference<ResourceSetResources>(){};
        ResponseEntity<ResourceSetResources> responseEntity = this.apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/resources", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<ResourceSetResources> newResponseEntity = this.apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/resources", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public ResourceSets listResourceSets(String after) throws RestClientException {
        return (ResourceSets)this.listResourceSetsWithHttpInfo(after).getBody();
    }

    public ResponseEntity<ResourceSets> listResourceSetsWithHttpInfo(String after) throws RestClientException {
        Object localVarPostBody = null;
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", after));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<ResourceSets> localReturnType = new ParameterizedTypeReference<ResourceSets>(){};
        return this.apiClient.invokeAPI("/api/v1/iam/resource-sets", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList listResourceSetsWithPaginationInfo(String after) throws RestClientException {
        Object localVarPostBody = null;
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", after));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<ResourceSets> localReturnType = new ParameterizedTypeReference<ResourceSets>(){};
        ResponseEntity<ResourceSets> responseEntity = this.apiClient.invokeAPI("/api/v1/iam/resource-sets", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<ResourceSets> newResponseEntity = this.apiClient.invokeAPI("/api/v1/iam/resource-sets", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public ResourceSet replaceResourceSet(String resourceSetId, ResourceSet instance) throws RestClientException {
        return (ResourceSet)this.replaceResourceSetWithHttpInfo(resourceSetId, instance).getBody();
    }

    public <T> T replaceResourceSet(Class<?> T, String resourceSetId, ResourceSet instance) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.replaceResourceSetWithReturnType(T, resourceSetId, instance).getBody(), T);
    }

    public ResponseEntity<ResourceSet> replaceResourceSetWithHttpInfo(String resourceSetId, ResourceSet instance) throws RestClientException {
        ResourceSet localVarPostBody = instance;
        if (resourceSetId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling replaceResourceSet");
        }
        if (instance == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling replaceResourceSet");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("resourceSetId", resourceSetId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<ResourceSet> localReturnType = new ParameterizedTypeReference<ResourceSet>(){};
        return this.apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> replaceResourceSetWithReturnType(Class<?> T, String resourceSetId, ResourceSet instance) throws RestClientException {
        ResourceSet localVarPostBody = instance;
        if (resourceSetId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling replaceResourceSet");
        }
        if (instance == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling replaceResourceSet");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("resourceSetId", resourceSetId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList replaceResourceSetWithPaginationInfo(String resourceSetId, ResourceSet instance) throws RestClientException {
        ResourceSet localVarPostBody = instance;
        if (resourceSetId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling replaceResourceSet");
        }
        if (instance == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling replaceResourceSet");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("resourceSetId", resourceSetId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<ResourceSet> localReturnType = new ParameterizedTypeReference<ResourceSet>(){};
        ResponseEntity<ResourceSet> responseEntity = this.apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<ResourceSet> newResponseEntity = this.apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public void unassignMemberFromBinding(String resourceSetId, String roleIdOrLabel, String memberId) throws RestClientException {
        this.unassignMemberFromBindingWithHttpInfo(resourceSetId, roleIdOrLabel, memberId);
    }

    public ResponseEntity<Void> unassignMemberFromBindingWithHttpInfo(String resourceSetId, String roleIdOrLabel, String memberId) throws RestClientException {
        Object localVarPostBody = null;
        if (resourceSetId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling unassignMemberFromBinding");
        }
        if (roleIdOrLabel == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleIdOrLabel' when calling unassignMemberFromBinding");
        }
        if (memberId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'memberId' when calling unassignMemberFromBinding");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("resourceSetId", resourceSetId);
        uriVariables.put("roleIdOrLabel", roleIdOrLabel);
        uriVariables.put("memberId", memberId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/bindings/{roleIdOrLabel}/members/{memberId}", HttpMethod.DELETE, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

