/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.commons.http.config.HttpClientConfiguration;
import com.okta.commons.lang.ApplicationInfo;
import com.okta.sdk.cache.Cache;
import com.okta.sdk.cache.CacheManager;
import com.okta.sdk.error.RetryableException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.ParseException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.openapitools.client.JavaTimeFormatter;
import org.openapitools.client.RFC3339DateFormat;
import org.openapitools.client.auth.ApiKeyAuth;
import org.openapitools.client.auth.Authentication;
import org.openapitools.client.auth.OAuth;
import org.openapitools.jackson.nullable.JsonNullableModule;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.BufferingClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.FixedBackOffPolicy;
import org.springframework.retry.policy.NeverRetryPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplateHandler;

@Component(value="org.openapitools.client.ApiClient")
public class ApiClient
extends JavaTimeFormatter {
    private boolean debugging = false;
    private HttpHeaders defaultHeaders = new HttpHeaders();
    private MultiValueMap<String, String> defaultCookies = new LinkedMultiValueMap();
    private String basePath = "https://subdomain.okta.com";
    private RestTemplate restTemplate;
    private RetryTemplate retryTemplate;
    private Map<String, Authentication> authentications;
    private DateFormat dateFormat;
    private Cache<String, ResponseEntity> cache;
    private CacheManager cacheManager;
    private HttpClientConfiguration httpClientConfiguration;

    public ApiClient() {
        this.init();
    }

    public ApiClient(RestTemplate restTemplate, CacheManager cacheManager) {
        this.restTemplate = restTemplate;
        this.cacheManager = cacheManager;
        this.init();
    }

    public ApiClient(RestTemplate restTemplate, CacheManager cacheManager, HttpClientConfiguration httpClientConfiguration) {
        this.restTemplate = restTemplate;
        this.cacheManager = cacheManager;
        this.httpClientConfiguration = httpClientConfiguration;
        this.init();
    }

    protected void init() {
        this.dateFormat = new RFC3339DateFormat();
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String userAgentValue = ApplicationInfo.get().entrySet().stream().map(entry -> (String)entry.getKey() + "/" + (String)entry.getValue()).collect(Collectors.joining(" "));
        this.setUserAgent(userAgentValue);
        this.authentications = new HashMap<String, Authentication>();
        this.authentications.put("apiToken", new ApiKeyAuth("header", "Authorization"));
        this.authentications.put("oauth2", new OAuth());
        this.authentications = Collections.unmodifiableMap(this.authentications);
        if (this.restTemplate == null) {
            this.restTemplate = this.buildRestTemplate();
        }
        this.retryTemplate = this.buildRetryTemplate();
        this.cache = this.cacheManager.getCache("default");
    }

    public String getBasePath() {
        return this.basePath;
    }

    public ApiClient setBasePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public Map<String, Authentication> getAuthentications() {
        return this.authentications;
    }

    public Authentication getAuthentication(String authName) {
        return this.authentications.get(authName);
    }

    public void setApiKey(String apiKey) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof ApiKeyAuth)) continue;
            ((ApiKeyAuth)auth).setApiKey(apiKey);
            return;
        }
        throw new RuntimeException("No API key authentication configured!");
    }

    public void setApiKeyPrefix(String apiKeyPrefix) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof ApiKeyAuth)) continue;
            ((ApiKeyAuth)auth).setApiKeyPrefix(apiKeyPrefix);
            return;
        }
        throw new RuntimeException("No API key authentication configured!");
    }

    public void setAccessToken(String accessToken) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof OAuth)) continue;
            ((OAuth)auth).setAccessToken(accessToken);
            return;
        }
        throw new RuntimeException("No OAuth2 authentication configured!");
    }

    public ApiClient setUserAgent(String userAgent) {
        this.addDefaultHeader("User-Agent", userAgent);
        return this;
    }

    public ApiClient addDefaultHeader(String name, String value) {
        if (this.defaultHeaders.containsKey((Object)name)) {
            this.defaultHeaders.remove((Object)name);
        }
        this.defaultHeaders.add(name, value);
        return this;
    }

    public ApiClient addDefaultCookie(String name, String value) {
        if (this.defaultCookies.containsKey((Object)name)) {
            this.defaultCookies.remove((Object)name);
        }
        this.defaultCookies.add((Object)name, (Object)value);
        return this;
    }

    public void setDebugging(boolean debugging) {
        ArrayList<ApiClientHttpRequestInterceptor> currentInterceptors = this.restTemplate.getInterceptors();
        if (debugging) {
            if (currentInterceptors == null) {
                currentInterceptors = new ArrayList<ApiClientHttpRequestInterceptor>();
            }
            ApiClientHttpRequestInterceptor interceptor = new ApiClientHttpRequestInterceptor();
            currentInterceptors.add(interceptor);
            this.restTemplate.setInterceptors(currentInterceptors);
        } else if (currentInterceptors != null && !currentInterceptors.isEmpty()) {
            Iterator iter = currentInterceptors.iterator();
            while (iter.hasNext()) {
                ClientHttpRequestInterceptor interceptor = (ClientHttpRequestInterceptor)iter.next();
                if (!(interceptor instanceof ApiClientHttpRequestInterceptor)) continue;
                iter.remove();
            }
            this.restTemplate.setInterceptors(currentInterceptors);
        }
        this.debugging = debugging;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public ApiClient setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
        return this;
    }

    public Date parseDate(String str) {
        try {
            return this.dateFormat.parse(str);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public String formatDate(Date date) {
        return this.dateFormat.format(date);
    }

    public String parameterToString(Object param) {
        if (param == null) {
            return "";
        }
        if (param instanceof Date) {
            return this.formatDate((Date)param);
        }
        if (param instanceof OffsetDateTime) {
            return this.formatOffsetDateTime((OffsetDateTime)param);
        }
        if (param instanceof Collection) {
            StringBuilder b = new StringBuilder();
            for (Object o : (Collection)param) {
                if (b.length() > 0) {
                    b.append(",");
                }
                b.append(String.valueOf(o));
            }
            return b.toString();
        }
        return String.valueOf(param);
    }

    public String collectionPathParameterToString(CollectionFormat collectionFormat, Collection<?> values) {
        if (CollectionFormat.MULTI.equals((Object)collectionFormat)) {
            return this.parameterToString(values);
        }
        if (collectionFormat == null) {
            collectionFormat = CollectionFormat.CSV;
        }
        return collectionFormat.collectionToString(values);
    }

    public MultiValueMap<String, String> parameterToMultiValueMap(CollectionFormat collectionFormat, String name, Object value) {
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        if (name == null || name.isEmpty() || value == null) {
            return params;
        }
        if (collectionFormat == null) {
            collectionFormat = CollectionFormat.CSV;
        }
        if (value instanceof Map) {
            Map valuesMap = (Map)value;
            for (Map.Entry entry : valuesMap.entrySet()) {
                params.add((Object)((String)entry.getKey()), (Object)this.parameterToString(entry.getValue()));
            }
            return params;
        }
        Collection valueCollection = null;
        if (!(value instanceof Collection)) {
            params.add((Object)name, (Object)this.parameterToString(value));
            return params;
        }
        valueCollection = (Collection)value;
        if (valueCollection.isEmpty()) {
            return params;
        }
        if (collectionFormat.equals((Object)CollectionFormat.MULTI)) {
            for (Object item : valueCollection) {
                params.add((Object)name, (Object)this.parameterToString(item));
            }
            return params;
        }
        ArrayList<String> values = new ArrayList<String>();
        for (Object o : valueCollection) {
            values.add(this.parameterToString(o));
        }
        params.add((Object)name, (Object)collectionFormat.collectionToString(values));
        return params;
    }

    public boolean isJsonMime(String mediaType) {
        if ("*/*".equals(mediaType)) {
            return true;
        }
        try {
            return this.isJsonMime(MediaType.parseMediaType((String)mediaType));
        }
        catch (InvalidMediaTypeException invalidMediaTypeException) {
            return false;
        }
    }

    public boolean isJsonMime(MediaType mediaType) {
        return mediaType != null && (MediaType.APPLICATION_JSON.isCompatibleWith(mediaType) || mediaType.getSubtype().matches("^.*\\+json[;]?\\s*$"));
    }

    public boolean isProblemJsonMime(String mediaType) {
        return "application/problem+json".equalsIgnoreCase(mediaType);
    }

    public List<MediaType> selectHeaderAccept(String[] accepts) {
        if (accepts.length == 0) {
            return null;
        }
        for (String accept : accepts) {
            MediaType mediaType = MediaType.parseMediaType((String)accept);
            if (!this.isJsonMime(mediaType) || this.isProblemJsonMime(accept)) continue;
            return Collections.singletonList(mediaType);
        }
        return MediaType.parseMediaTypes((String)StringUtils.arrayToCommaDelimitedString((Object[])accepts));
    }

    public MediaType selectHeaderContentType(String[] contentTypes) {
        if (contentTypes.length == 0) {
            return MediaType.APPLICATION_JSON;
        }
        for (String contentType : contentTypes) {
            MediaType mediaType = MediaType.parseMediaType((String)contentType);
            if (!this.isJsonMime(mediaType)) continue;
            return mediaType;
        }
        return MediaType.parseMediaType((String)contentTypes[0]);
    }

    protected Object selectBody(Object obj, MultiValueMap<String, Object> formParams, MediaType contentType) {
        boolean isForm = MediaType.MULTIPART_FORM_DATA.isCompatibleWith(contentType) || MediaType.APPLICATION_FORM_URLENCODED.isCompatibleWith(contentType);
        return isForm ? formParams : obj;
    }

    public String expandPath(String pathTemplate, Map<String, Object> variables) {
        return this.restTemplate.getUriTemplateHandler().expand(pathTemplate, variables).toString();
    }

    public String generateQueryUri(MultiValueMap<String, String> queryParams, Map<String, Object> uriParams) {
        StringBuilder queryBuilder = new StringBuilder();
        queryParams.forEach((name, values) -> {
            try {
                String encodedName = URLEncoder.encode(name.toString(), "UTF-8");
                if (CollectionUtils.isEmpty((Collection)values)) {
                    if (queryBuilder.length() != 0) {
                        queryBuilder.append('&');
                    }
                    queryBuilder.append(encodedName);
                } else {
                    int valueItemCounter = 0;
                    for (Object value : values) {
                        if (queryBuilder.length() != 0) {
                            queryBuilder.append('&');
                        }
                        queryBuilder.append(encodedName);
                        if (value == null) continue;
                        String templatizedKey = encodedName + valueItemCounter++;
                        uriParams.put(templatizedKey, value.toString());
                        queryBuilder.append('=').append("{").append(templatizedKey).append("}");
                    }
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        });
        return queryBuilder.toString();
    }

    public <T> ResponseEntity<T> invokeAPI(String path, HttpMethod method, Map<String, Object> pathParams, MultiValueMap<String, String> queryParams, Object body, HttpHeaders headerParams, MultiValueMap<String, String> cookieParams, MultiValueMap<String, Object> formParams, List<MediaType> accept, MediaType contentType, String[] authNames, ParameterizedTypeReference<T> returnType) throws RestClientException {
        String key;
        String[] uriSegments;
        URI uri;
        this.updateParamsForAuth(authNames, queryParams, headerParams, cookieParams);
        HashMap<String, Object> uriParams = new HashMap<String, Object>();
        uriParams.putAll(pathParams);
        String finalUri = path;
        if (queryParams != null && !queryParams.isEmpty()) {
            String queryUri = this.generateQueryUri(queryParams, uriParams);
            finalUri = finalUri + "?" + queryUri;
        }
        String expandedPath = this.expandPath(finalUri, uriParams);
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)this.basePath).path(expandedPath);
        try {
            uri = new URI(builder.build().toUriString());
        }
        catch (URISyntaxException ex) {
            throw new RestClientException("Could not build URL: " + builder.toUriString(), (Throwable)ex);
        }
        RequestEntity.BodyBuilder requestBuilder = RequestEntity.method((HttpMethod)method, (URI)uri);
        if (accept != null) {
            requestBuilder.accept(accept.toArray(new MediaType[accept.size()]));
        }
        if (contentType != null) {
            requestBuilder.contentType(contentType);
        }
        this.addHeadersToRequest(headerParams, requestBuilder);
        this.addHeadersToRequest(this.defaultHeaders, requestBuilder);
        this.addCookiesToRequest(cookieParams, requestBuilder);
        this.addCookiesToRequest(this.defaultCookies, requestBuilder);
        RequestEntity requestEntity = requestBuilder.body(this.selectBody(body, formParams, contentType));
        String cacheKey = requestEntity.getUrl().toString();
        if (Objects.nonNull(requestEntity.getUrl().getQuery())) {
            cacheKey = requestEntity.getUrl().toString().split("\\?")[0];
        }
        if (method == HttpMethod.DELETE) {
            this.cache.remove(cacheKey);
        }
        if ((uriSegments = uri.getPath().split("/")) != null && uriSegments.length >= 5 && this.cache.get(key = this.getBasePath() + "/" + uriSegments[1] + "/" + uriSegments[2] + "/" + uriSegments[3] + "/" + uriSegments[4]) != null) {
            this.cache.remove(key);
        }
        if (!(method != HttpMethod.GET || returnType.getType().getTypeName().contains("List") || Objects.nonNull(requestEntity.getUrl().getQuery()) && requestEntity.getUrl().getQuery().contains("expand"))) {
            ResponseEntity cacheData = this.cache.get(cacheKey);
            if (Objects.isNull(cacheData) || !cacheData.hasBody()) {
                ResponseEntity responseEntity = (ResponseEntity)this.retryTemplate.execute(context -> this.restTemplate.exchange(requestEntity, returnType));
                if (responseEntity != null && responseEntity.getStatusCode().is2xxSuccessful()) {
                    if (method == HttpMethod.GET && Objects.nonNull(responseEntity.getBody())) {
                        LinkedHashMap self;
                        Map links;
                        Map map = (Map)this.objectMapper().convertValue(responseEntity.getBody(), LinkedHashMap.class);
                        String href = null;
                        if (Objects.nonNull(map) && Objects.nonNull(links = (Map)map.get("_links")) && Objects.nonNull(self = (LinkedHashMap)links.get("self"))) {
                            href = (String)self.get("href");
                        }
                        if (Objects.nonNull(href)) {
                            this.cache.put(href, responseEntity);
                        } else {
                            this.cache.put(cacheKey, responseEntity);
                        }
                    }
                    return responseEntity;
                }
                throw new RestClientException("API returned " + responseEntity.getStatusCode() + " and it wasn't handled by the RestTemplate error handler");
            }
            return this.cache.get(cacheKey);
        }
        ResponseEntity responseEntity = (ResponseEntity)this.retryTemplate.execute(context -> this.restTemplate.exchange(requestEntity, returnType));
        if (responseEntity != null && responseEntity.getStatusCode().is2xxSuccessful()) {
            if (this.cache.get(cacheKey) != null) {
                this.cache.put(cacheKey, responseEntity);
            }
            return responseEntity;
        }
        throw new RestClientException("API returned " + responseEntity.getStatusCode() + " and it wasn't handled by the RestTemplate error handler");
    }

    protected void addHeadersToRequest(HttpHeaders headers, RequestEntity.BodyBuilder requestBuilder) {
        for (Map.Entry entry : headers.entrySet()) {
            List values = (List)entry.getValue();
            for (String value : values) {
                if (value == null) continue;
                requestBuilder.header((String)entry.getKey(), new String[]{value});
            }
        }
    }

    protected void addCookiesToRequest(MultiValueMap<String, String> cookies, RequestEntity.BodyBuilder requestBuilder) {
        if (!cookies.isEmpty()) {
            requestBuilder.header("Cookie", new String[]{this.buildCookieHeader(cookies)});
        }
    }

    private String buildCookieHeader(MultiValueMap<String, String> cookies) {
        StringBuilder cookieValue = new StringBuilder();
        String delimiter = "";
        for (Map.Entry entry : cookies.entrySet()) {
            String value = (String)((List)entry.getValue()).get(((List)entry.getValue()).size() - 1);
            cookieValue.append(String.format("%s%s=%s", delimiter, entry.getKey(), value));
            delimiter = "; ";
        }
        return cookieValue.toString();
    }

    protected RestTemplate buildRestTemplate() {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setRequestFactory((ClientHttpRequestFactory)new BufferingClientHttpRequestFactory(this.getClientHttpRequestFactory()));
        DefaultUriBuilderFactory uriBuilderFactory = new DefaultUriBuilderFactory();
        uriBuilderFactory.setEncodingMode(DefaultUriBuilderFactory.EncodingMode.VALUES_ONLY);
        restTemplate.setUriTemplateHandler((UriTemplateHandler)uriBuilderFactory);
        return restTemplate;
    }

    private ClientHttpRequestFactory getClientHttpRequestFactory() {
        int timeout = 5000;
        RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).setSocketTimeout(timeout).build();
        CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
        return new HttpComponentsClientHttpRequestFactory((HttpClient)client);
    }

    protected RetryTemplate buildRetryTemplate() {
        RetryTemplate retryTemplate = new RetryTemplate();
        if (this.httpClientConfiguration.getConnectionTimeout() == 0 && this.httpClientConfiguration.getRetryMaxAttempts() == 0) {
            NeverRetryPolicy retryPolicy = new NeverRetryPolicy();
            retryTemplate.setRetryPolicy((RetryPolicy)retryPolicy);
            return retryTemplate;
        }
        HashMap<Class<RetryableException>, Boolean> retryableExceptions = new HashMap<Class<RetryableException>, Boolean>();
        retryableExceptions.put(RetryableException.class, Boolean.TRUE);
        SimpleRetryPolicy retryPolicy = new SimpleRetryPolicy(this.httpClientConfiguration.getRetryMaxAttempts(), retryableExceptions);
        FixedBackOffPolicy backOffPolicy = new FixedBackOffPolicy();
        retryTemplate.setRetryPolicy((RetryPolicy)retryPolicy);
        retryTemplate.setBackOffPolicy((BackOffPolicy)backOffPolicy);
        retryTemplate.setThrowLastExceptionOnExhausted(true);
        return retryTemplate;
    }

    private ObjectMapper objectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        return objectMapper;
    }

    protected void updateParamsForAuth(String[] authNames, MultiValueMap<String, String> queryParams, HttpHeaders headerParams, MultiValueMap<String, String> cookieParams) {
        for (String authName : authNames) {
            Authentication auth = this.authentications.get(authName);
            if (auth == null) {
                throw new RestClientException("Authentication undefined: " + authName);
            }
            auth.applyToParams(queryParams, headerParams, cookieParams);
        }
    }

    private class ApiClientHttpRequestInterceptor
    implements ClientHttpRequestInterceptor {
        private final Log logger = LogFactory.getLog(ApiClientHttpRequestInterceptor.class);

        private ApiClientHttpRequestInterceptor() {
        }

        public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
            this.logRequest(request, body);
            ClientHttpResponse response = execution.execute(request, body);
            this.logResponse(response);
            return response;
        }

        private void logRequest(HttpRequest request, byte[] body) throws UnsupportedEncodingException {
            this.logger.info((Object)("URI: " + request.getMethod() + " " + request.getURI()));
            this.logger.info((Object)("Request Headers: " + this.headersToString(request.getHeaders())));
            this.logger.info((Object)("Request Body: " + new String(body, StandardCharsets.UTF_8)));
        }

        private void logResponse(ClientHttpResponse response) throws IOException {
            this.logger.info((Object)("Response Status: " + response.getRawStatusCode() + " " + response.getStatusText()));
            this.logger.info((Object)("Response Headers: " + this.headersToString(response.getHeaders())));
            this.logger.info((Object)("Response Body: " + StreamUtils.copyToString((InputStream)response.getBody(), (Charset)Charset.defaultCharset())));
        }

        private String headersToString(HttpHeaders headers) {
            if (headers == null || headers.isEmpty()) {
                return "";
            }
            StringBuilder builder = new StringBuilder();
            for (Map.Entry entry : headers.entrySet()) {
                builder.append((String)entry.getKey()).append("=[");
                for (String value : (List)entry.getValue()) {
                    if (((String)entry.getKey()).equals("Authorization")) {
                        builder.append("*****").append(",");
                        continue;
                    }
                    builder.append(value).append(",");
                }
                builder.setLength(builder.length() - 1);
                builder.append("],");
            }
            builder.setLength(builder.length() - 1);
            return builder.toString();
        }
    }

    public static enum CollectionFormat {
        CSV(","),
        TSV("\t"),
        SSV(" "),
        PIPES("|"),
        MULTI(null);

        private final String separator;

        private CollectionFormat(String separator) {
            this.separator = separator;
        }

        private String collectionToString(Collection<?> collection) {
            return StringUtils.collectionToDelimitedString(collection, (String)this.separator);
        }
    }
}

