/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.common;

import com.okta.commons.lang.Assert;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.http.ResponseEntity;

public class PagedList<T> {
    private List<T> items;
    private String self;
    private String nextPage;

    public List<T> getItems() {
        return this.items;
    }

    public String getSelf() {
        return this.self;
    }

    public String getNextPage() {
        return this.nextPage;
    }

    public String getAfter(String nextPageUrl) {
        try {
            URL url = new URL(nextPageUrl);
            return PagedList.splitQuery(url).get("after");
        }
        catch (UnsupportedEncodingException | MalformedURLException e) {
            return null;
        }
    }

    public void setSelf(String self) {
        this.self = self;
    }

    public void addItems(List<T> itemsToAdd) {
        this.items = this.flatten(itemsToAdd);
    }

    public List<T> items() {
        return this.getItems();
    }

    public void setNextPage(String nextPage) {
        this.nextPage = nextPage;
    }

    private List<?> flatten(List<?> list) {
        return list.stream().flatMap(e -> e instanceof List ? this.flatten((List)e).stream() : Stream.of(e)).collect(Collectors.toList());
    }

    public static PagedList constructPagedList(ResponseEntity responseEntity) {
        PagedList<Object> pagedList = new PagedList<Object>();
        Assert.notNull((Object)responseEntity);
        pagedList.addItems(Collections.singletonList(responseEntity.getBody()));
        List linkHeaders = responseEntity.getHeaders().get((Object)"link");
        Assert.notNull((Object)linkHeaders);
        for (String link : linkHeaders) {
            String[] parts = link.split("; *");
            String url = parts[0].replaceAll("<", "").replaceAll(">", "");
            String rel = parts[1];
            if (rel.equals("rel=\"next\"")) {
                pagedList.setNextPage(url);
                continue;
            }
            if (!rel.equals("rel=\"self\"")) continue;
            pagedList.setSelf(url);
        }
        return pagedList;
    }

    private static Map<String, String> splitQuery(URL url) throws UnsupportedEncodingException {
        String[] pairs;
        LinkedHashMap<String, String> query_pairs = new LinkedHashMap<String, String>();
        String query = url.getQuery();
        for (String pair : pairs = query.split("&")) {
            int index = pair.indexOf("=");
            query_pairs.put(URLDecoder.decode(pair.substring(0, index), "UTF-8"), URLDecoder.decode(pair.substring(index + 1), "UTF-8"));
        }
        return query_pairs;
    }
}

