/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.error;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.okta.commons.lang.Strings;
import com.okta.sdk.error.Error;
import com.okta.sdk.error.ErrorCause;
import com.okta.sdk.error.NonJsonError;
import com.okta.sdk.error.ResourceException;
import com.okta.sdk.error.RetryableException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.client.ResponseErrorHandler;

public class ErrorHandler
implements ResponseErrorHandler {
    static final String ERROR_PROPERTY = "error";
    static final String ERROR_DESC_PROPERTY = "error_description";
    static final String ERROR_CODE_PROPERTY = "errorCode";
    static final String ERROR_ID_PROPERTY = "errorId";
    static final String ERROR_SUMMARY_PROPERTY = "errorSummary";
    static final String ERROR_CAUSES_PROPERTY = "errorCauses";
    private final ObjectMapper mapper = new ObjectMapper();

    public boolean hasError(ClientHttpResponse httpResponse) throws IOException {
        return httpResponse.getStatusCode().series() == HttpStatus.Series.CLIENT_ERROR || httpResponse.getStatusCode().series() == HttpStatus.Series.SERVER_ERROR;
    }

    public void handleError(ClientHttpResponse httpResponse) throws IOException, ResourceException {
        final int statusCode = httpResponse.getRawStatusCode();
        String message = new String(FileCopyUtils.copyToByteArray((InputStream)httpResponse.getBody()));
        if (!this.isValid(message)) {
            if (!Strings.hasText((String)message)) {
                message = httpResponse.getStatusText();
            }
            throw new ResourceException(new NonJsonError(statusCode, message));
        }
        final Map errorMap = (Map)this.mapper.readValue(message, Map.class);
        HttpHeaders responseHeaders = httpResponse.getHeaders();
        Error error = new Error(){
            final /* synthetic */ Map val$responseHeaders;
            {
                this.val$responseHeaders = map2;
            }

            @Override
            public int getStatus() {
                return statusCode;
            }

            @Override
            public String getCode() {
                if (Objects.nonNull(errorMap.get(ErrorHandler.ERROR_CODE_PROPERTY))) {
                    return String.valueOf(errorMap.get(ErrorHandler.ERROR_CODE_PROPERTY));
                }
                return null;
            }

            @Override
            public String getMessage() {
                StringBuilder stringBuilder = new StringBuilder();
                if (Objects.nonNull(errorMap.get(ErrorHandler.ERROR_PROPERTY))) {
                    stringBuilder.append(errorMap.get(ErrorHandler.ERROR_PROPERTY) + ", ");
                }
                if (Objects.nonNull(errorMap.get(ErrorHandler.ERROR_DESC_PROPERTY))) {
                    stringBuilder.append(errorMap.get(ErrorHandler.ERROR_DESC_PROPERTY));
                }
                if (Objects.nonNull(errorMap.get(ErrorHandler.ERROR_SUMMARY_PROPERTY))) {
                    stringBuilder.append(errorMap.get(ErrorHandler.ERROR_SUMMARY_PROPERTY));
                }
                return stringBuilder.toString();
            }

            @Override
            public String getId() {
                if (Objects.nonNull(errorMap.get(ErrorHandler.ERROR_ID_PROPERTY))) {
                    return String.valueOf(errorMap.get(ErrorHandler.ERROR_ID_PROPERTY));
                }
                return null;
            }

            @Override
            public List<ErrorCause> getCauses() {
                ArrayList results = new ArrayList();
                Object rawProp = errorMap.get(ErrorHandler.ERROR_CAUSES_PROPERTY);
                if (rawProp instanceof List) {
                    ((List)rawProp).forEach(causeMap -> results.add(new ErrorCause(String.valueOf(causeMap.get(ErrorHandler.ERROR_SUMMARY_PROPERTY)))));
                }
                return Collections.unmodifiableList(results);
            }

            @Override
            public Map<String, List<String>> getHeaders() {
                return Collections.unmodifiableMap(this.val$responseHeaders);
            }
        };
        if (statusCode == 429) {
            throw new RetryableException(error);
        }
        throw new ResourceException(error);
    }

    boolean isValid(String json) {
        try {
            this.mapper.readTree(json);
        }
        catch (JacksonException e) {
            return false;
        }
        return true;
    }
}

