/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.common.PagedList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.openapitools.client.ApiClient;
import org.openapitools.client.model.ApplicationLayout;
import org.openapitools.client.model.GroupSchema;
import org.openapitools.client.model.LogStreamSchema;
import org.openapitools.client.model.LogStreamType;
import org.openapitools.client.model.UserSchema;
import org.openapitools.jackson.nullable.JsonNullableModule;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

@Component(value="org.openapitools.client.api.SchemaApi")
public class SchemaApi {
    private ApiClient apiClient;

    public SchemaApi() {
        this(new ApiClient());
    }

    @Autowired
    public SchemaApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApplicationLayout getApplicationLayout(String appName) throws RestClientException {
        return (ApplicationLayout)this.getApplicationLayoutWithHttpInfo(appName).getBody();
    }

    public ResponseEntity<ApplicationLayout> getApplicationLayoutWithHttpInfo(String appName) throws RestClientException {
        Object localVarPostBody = null;
        if (appName == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appName' when calling getApplicationLayout");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appName", appName);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<ApplicationLayout> localReturnType = new ParameterizedTypeReference<ApplicationLayout>(){};
        return this.apiClient.invokeAPI("/api/v1/meta/layouts/apps/{appName}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList getApplicationLayoutWithPaginationInfo(String appName) throws RestClientException {
        Object localVarPostBody = null;
        if (appName == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appName' when calling getApplicationLayout");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appName", appName);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<ApplicationLayout> localReturnType = new ParameterizedTypeReference<ApplicationLayout>(){};
        ResponseEntity<ApplicationLayout> responseEntity = this.apiClient.invokeAPI("/api/v1/meta/layouts/apps/{appName}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<ApplicationLayout> newResponseEntity = this.apiClient.invokeAPI("/api/v1/meta/layouts/apps/{appName}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public UserSchema getApplicationUserSchema(String appInstanceId) throws RestClientException {
        return (UserSchema)this.getApplicationUserSchemaWithHttpInfo(appInstanceId).getBody();
    }

    public ResponseEntity<UserSchema> getApplicationUserSchemaWithHttpInfo(String appInstanceId) throws RestClientException {
        Object localVarPostBody = null;
        if (appInstanceId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appInstanceId' when calling getApplicationUserSchema");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appInstanceId", appInstanceId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<UserSchema> localReturnType = new ParameterizedTypeReference<UserSchema>(){};
        return this.apiClient.invokeAPI("/api/v1/meta/schemas/apps/{appInstanceId}/default", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList getApplicationUserSchemaWithPaginationInfo(String appInstanceId) throws RestClientException {
        Object localVarPostBody = null;
        if (appInstanceId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appInstanceId' when calling getApplicationUserSchema");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appInstanceId", appInstanceId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<UserSchema> localReturnType = new ParameterizedTypeReference<UserSchema>(){};
        ResponseEntity<UserSchema> responseEntity = this.apiClient.invokeAPI("/api/v1/meta/schemas/apps/{appInstanceId}/default", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<UserSchema> newResponseEntity = this.apiClient.invokeAPI("/api/v1/meta/schemas/apps/{appInstanceId}/default", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public GroupSchema getGroupSchema() throws RestClientException {
        return (GroupSchema)this.getGroupSchemaWithHttpInfo().getBody();
    }

    public ResponseEntity<GroupSchema> getGroupSchemaWithHttpInfo() throws RestClientException {
        Object localVarPostBody = null;
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<GroupSchema> localReturnType = new ParameterizedTypeReference<GroupSchema>(){};
        return this.apiClient.invokeAPI("/api/v1/meta/schemas/group/default", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList getGroupSchemaWithPaginationInfo() throws RestClientException {
        Object localVarPostBody = null;
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<GroupSchema> localReturnType = new ParameterizedTypeReference<GroupSchema>(){};
        ResponseEntity<GroupSchema> responseEntity = this.apiClient.invokeAPI("/api/v1/meta/schemas/group/default", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<GroupSchema> newResponseEntity = this.apiClient.invokeAPI("/api/v1/meta/schemas/group/default", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public LogStreamSchema getLogStreamSchema(LogStreamType logStreamType) throws RestClientException {
        return (LogStreamSchema)this.getLogStreamSchemaWithHttpInfo(logStreamType).getBody();
    }

    public ResponseEntity<LogStreamSchema> getLogStreamSchemaWithHttpInfo(LogStreamType logStreamType) throws RestClientException {
        Object localVarPostBody = null;
        if (logStreamType == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'logStreamType' when calling getLogStreamSchema");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("logStreamType", (Object)logStreamType);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<LogStreamSchema> localReturnType = new ParameterizedTypeReference<LogStreamSchema>(){};
        return this.apiClient.invokeAPI("/api/v1/meta/schemas/logStream/{logStreamType}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList getLogStreamSchemaWithPaginationInfo(LogStreamType logStreamType) throws RestClientException {
        Object localVarPostBody = null;
        if (logStreamType == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'logStreamType' when calling getLogStreamSchema");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("logStreamType", (Object)logStreamType);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<LogStreamSchema> localReturnType = new ParameterizedTypeReference<LogStreamSchema>(){};
        ResponseEntity<LogStreamSchema> responseEntity = this.apiClient.invokeAPI("/api/v1/meta/schemas/logStream/{logStreamType}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<LogStreamSchema> newResponseEntity = this.apiClient.invokeAPI("/api/v1/meta/schemas/logStream/{logStreamType}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public UserSchema getUserSchema(String schemaId) throws RestClientException {
        return (UserSchema)this.getUserSchemaWithHttpInfo(schemaId).getBody();
    }

    public ResponseEntity<UserSchema> getUserSchemaWithHttpInfo(String schemaId) throws RestClientException {
        Object localVarPostBody = null;
        if (schemaId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'schemaId' when calling getUserSchema");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("schemaId", schemaId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<UserSchema> localReturnType = new ParameterizedTypeReference<UserSchema>(){};
        return this.apiClient.invokeAPI("/api/v1/meta/schemas/user/{schemaId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList getUserSchemaWithPaginationInfo(String schemaId) throws RestClientException {
        Object localVarPostBody = null;
        if (schemaId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'schemaId' when calling getUserSchema");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("schemaId", schemaId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<UserSchema> localReturnType = new ParameterizedTypeReference<UserSchema>(){};
        ResponseEntity<UserSchema> responseEntity = this.apiClient.invokeAPI("/api/v1/meta/schemas/user/{schemaId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<UserSchema> newResponseEntity = this.apiClient.invokeAPI("/api/v1/meta/schemas/user/{schemaId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public List<LogStreamSchema> listLogStreamSchemas() throws RestClientException {
        return (List)this.listLogStreamSchemasWithHttpInfo().getBody();
    }

    public ResponseEntity<List<LogStreamSchema>> listLogStreamSchemasWithHttpInfo() throws RestClientException {
        Object localVarPostBody = null;
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<LogStreamSchema>> localReturnType = new ParameterizedTypeReference<List<LogStreamSchema>>(){};
        return this.apiClient.invokeAPI("/api/v1/meta/schemas/logStream", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList listLogStreamSchemasWithPaginationInfo() throws RestClientException {
        Object localVarPostBody = null;
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<LogStreamSchema>> localReturnType = new ParameterizedTypeReference<List<LogStreamSchema>>(){};
        ResponseEntity<List<LogStreamSchema>> responseEntity = this.apiClient.invokeAPI("/api/v1/meta/schemas/logStream", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<List<LogStreamSchema>> newResponseEntity = this.apiClient.invokeAPI("/api/v1/meta/schemas/logStream", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public UserSchema updateApplicationUserProfile(String appInstanceId, UserSchema body) throws RestClientException {
        return (UserSchema)this.updateApplicationUserProfileWithHttpInfo(appInstanceId, body).getBody();
    }

    public <T> T updateApplicationUserProfile(Class<?> T, String appInstanceId, UserSchema body) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.updateApplicationUserProfileWithReturnType(T, appInstanceId, body).getBody(), T);
    }

    public ResponseEntity<UserSchema> updateApplicationUserProfileWithHttpInfo(String appInstanceId, UserSchema body) throws RestClientException {
        UserSchema localVarPostBody = body;
        if (appInstanceId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appInstanceId' when calling updateApplicationUserProfile");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appInstanceId", appInstanceId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<UserSchema> localReturnType = new ParameterizedTypeReference<UserSchema>(){};
        return this.apiClient.invokeAPI("/api/v1/meta/schemas/apps/{appInstanceId}/default", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> updateApplicationUserProfileWithReturnType(Class<?> T, String appInstanceId, UserSchema body) throws RestClientException {
        UserSchema localVarPostBody = body;
        if (appInstanceId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appInstanceId' when calling updateApplicationUserProfile");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appInstanceId", appInstanceId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/meta/schemas/apps/{appInstanceId}/default", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList updateApplicationUserProfileWithPaginationInfo(String appInstanceId, UserSchema body) throws RestClientException {
        UserSchema localVarPostBody = body;
        if (appInstanceId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appInstanceId' when calling updateApplicationUserProfile");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appInstanceId", appInstanceId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<UserSchema> localReturnType = new ParameterizedTypeReference<UserSchema>(){};
        ResponseEntity<UserSchema> responseEntity = this.apiClient.invokeAPI("/api/v1/meta/schemas/apps/{appInstanceId}/default", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<UserSchema> newResponseEntity = this.apiClient.invokeAPI("/api/v1/meta/schemas/apps/{appInstanceId}/default", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public GroupSchema updateGroupSchema(GroupSchema groupSchema) throws RestClientException {
        return (GroupSchema)this.updateGroupSchemaWithHttpInfo(groupSchema).getBody();
    }

    public <T> T updateGroupSchema(Class<?> T, GroupSchema groupSchema) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.updateGroupSchemaWithReturnType(T, groupSchema).getBody(), T);
    }

    public ResponseEntity<GroupSchema> updateGroupSchemaWithHttpInfo(GroupSchema groupSchema) throws RestClientException {
        GroupSchema localVarPostBody = groupSchema;
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<GroupSchema> localReturnType = new ParameterizedTypeReference<GroupSchema>(){};
        return this.apiClient.invokeAPI("/api/v1/meta/schemas/group/default", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> updateGroupSchemaWithReturnType(Class<?> T, GroupSchema groupSchema) throws RestClientException {
        GroupSchema localVarPostBody = groupSchema;
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/meta/schemas/group/default", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList updateGroupSchemaWithPaginationInfo(GroupSchema groupSchema) throws RestClientException {
        GroupSchema localVarPostBody = groupSchema;
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<GroupSchema> localReturnType = new ParameterizedTypeReference<GroupSchema>(){};
        ResponseEntity<GroupSchema> responseEntity = this.apiClient.invokeAPI("/api/v1/meta/schemas/group/default", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<GroupSchema> newResponseEntity = this.apiClient.invokeAPI("/api/v1/meta/schemas/group/default", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public UserSchema updateUserProfile(String schemaId, UserSchema userSchema) throws RestClientException {
        return (UserSchema)this.updateUserProfileWithHttpInfo(schemaId, userSchema).getBody();
    }

    public <T> T updateUserProfile(Class<?> T, String schemaId, UserSchema userSchema) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.updateUserProfileWithReturnType(T, schemaId, userSchema).getBody(), T);
    }

    public ResponseEntity<UserSchema> updateUserProfileWithHttpInfo(String schemaId, UserSchema userSchema) throws RestClientException {
        UserSchema localVarPostBody = userSchema;
        if (schemaId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'schemaId' when calling updateUserProfile");
        }
        if (userSchema == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userSchema' when calling updateUserProfile");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("schemaId", schemaId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<UserSchema> localReturnType = new ParameterizedTypeReference<UserSchema>(){};
        return this.apiClient.invokeAPI("/api/v1/meta/schemas/user/{schemaId}", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> updateUserProfileWithReturnType(Class<?> T, String schemaId, UserSchema userSchema) throws RestClientException {
        UserSchema localVarPostBody = userSchema;
        if (schemaId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'schemaId' when calling updateUserProfile");
        }
        if (userSchema == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userSchema' when calling updateUserProfile");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("schemaId", schemaId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/meta/schemas/user/{schemaId}", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList updateUserProfileWithPaginationInfo(String schemaId, UserSchema userSchema) throws RestClientException {
        UserSchema localVarPostBody = userSchema;
        if (schemaId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'schemaId' when calling updateUserProfile");
        }
        if (userSchema == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userSchema' when calling updateUserProfile");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("schemaId", schemaId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<UserSchema> localReturnType = new ParameterizedTypeReference<UserSchema>(){};
        ResponseEntity<UserSchema> responseEntity = this.apiClient.invokeAPI("/api/v1/meta/schemas/user/{schemaId}", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<UserSchema> newResponseEntity = this.apiClient.invokeAPI("/api/v1/meta/schemas/user/{schemaId}", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    private ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }
}

