/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.error;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.okta.sdk.error.Error;
import com.okta.sdk.error.ErrorCause;
import com.okta.sdk.error.NonJsonError;
import com.okta.sdk.error.ResourceException;
import com.okta.sdk.error.RetryableException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.client.ResponseErrorHandler;

public class ErrorHandler
implements ResponseErrorHandler {
    static final String ERROR_ID_PROPERTY = "errorId";
    static final String SUMMARY_PROPERTY = "errorSummary";
    static final String CAUSES_PROPERTY = "errorCauses";
    static final String HEADERS_PROPERTY = "errorHeaders";
    private final ObjectMapper mapper = new ObjectMapper();

    public boolean hasError(ClientHttpResponse httpResponse) throws IOException {
        return httpResponse.getStatusCode().series() == HttpStatus.Series.CLIENT_ERROR || httpResponse.getStatusCode().series() == HttpStatus.Series.SERVER_ERROR;
    }

    public void handleError(ClientHttpResponse httpResponse) throws IOException, ResourceException {
        final int statusCode = httpResponse.getRawStatusCode();
        String message = new String(FileCopyUtils.copyToByteArray((InputStream)httpResponse.getBody()));
        if (!this.isValid(message)) {
            throw new ResourceException(new NonJsonError(message));
        }
        final Map errorMap = (Map)this.mapper.readValue(message, Map.class);
        Error error = new Error(){

            @Override
            public int getStatus() {
                return statusCode;
            }

            @Override
            public String getCode() {
                return String.valueOf(statusCode);
            }

            @Override
            public String getMessage() {
                return String.valueOf(errorMap.get(ErrorHandler.SUMMARY_PROPERTY));
            }

            @Override
            public String getId() {
                return String.valueOf(errorMap.get(ErrorHandler.ERROR_ID_PROPERTY));
            }

            @Override
            public List<ErrorCause> getCauses() {
                ArrayList results = new ArrayList();
                Object rawProp = errorMap.get(ErrorHandler.CAUSES_PROPERTY);
                if (rawProp instanceof List) {
                    ((List)rawProp).forEach(causeMap -> results.add(new ErrorCause(String.valueOf(causeMap.get(ErrorHandler.SUMMARY_PROPERTY)))));
                }
                return Collections.unmodifiableList(results);
            }

            @Override
            public Map<String, List<String>> getHeaders() {
                HashMap<String, ArrayList> results = new HashMap<String, ArrayList>();
                Object rawProp = errorMap.get(ErrorHandler.HEADERS_PROPERTY);
                if (rawProp instanceof List) {
                    results.put(ErrorHandler.HEADERS_PROPERTY, (ArrayList)rawProp);
                }
                return Collections.unmodifiableMap(results);
            }
        };
        if (statusCode == 429) {
            throw new RetryableException(error);
        }
        throw new ResourceException(error);
    }

    boolean isValid(String json) {
        try {
            this.mapper.readTree(json);
        }
        catch (JacksonException e) {
            return false;
        }
        return true;
    }
}

