package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets SessionAuthenticationMethod
 */
public enum SessionAuthenticationMethod {
  
  FPT("fpt"),
  
  GEO("geo"),
  
  HWK("hwk"),
  
  KBA("kba"),
  
  MCA("mca"),
  
  MFA("mfa"),
  
  OTP("otp"),
  
  PWD("pwd"),
  
  SC("sc"),
  
  SMS("sms"),
  
  SWK("swk"),
  
  TEL("tel");

  private String value;

  SessionAuthenticationMethod(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static SessionAuthenticationMethod fromValue(String value) {
    for (SessionAuthenticationMethod b : SessionAuthenticationMethod.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

