package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets RoleType
 */
public enum RoleType {
  
  API_ACCESS_MANAGEMENT_ADMIN("API_ACCESS_MANAGEMENT_ADMIN"),
  
  APP_ADMIN("APP_ADMIN"),
  
  GROUP_MEMBERSHIP_ADMIN("GROUP_MEMBERSHIP_ADMIN"),
  
  HELP_DESK_ADMIN("HELP_DESK_ADMIN"),
  
  MOBILE_ADMIN("MOBILE_ADMIN"),
  
  ORG_ADMIN("ORG_ADMIN"),
  
  READ_ONLY_ADMIN("READ_ONLY_ADMIN"),
  
  REPORT_ADMIN("REPORT_ADMIN"),
  
  SUPER_ADMIN("SUPER_ADMIN"),
  
  USER_ADMIN("USER_ADMIN");

  private String value;

  RoleType(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static RoleType fromValue(String value) {
    for (RoleType b : RoleType.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

