package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import io.swagger.annotations.ApiModel;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * The action taken by Okta during authentication attempts based on the risk events sent by this provider. Logging can be found in the SystemLogs.
 */
public enum RiskProviderAction {
  
  ENFORCE_AND_LOG("enforce_and_log"),
  
  LOG_ONLY("log_only"),
  
  NONE("none");

  private String value;

  RiskProviderAction(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static RiskProviderAction fromValue(String value) {
    for (RiskProviderAction b : RiskProviderAction.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

