package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonInclude;
    import com.fasterxml.jackson.annotation.JsonProperty;
    import com.fasterxml.jackson.annotation.JsonCreator;
    import com.fasterxml.jackson.annotation.JsonTypeName;
    import com.fasterxml.jackson.annotation.JsonValue;
    import io.swagger.annotations.ApiModel;
    import io.swagger.annotations.ApiModelProperty;
    import java.time.OffsetDateTime;
    import org.openapitools.client.model.ApiTokenLink;
    import org.openapitools.client.model.RiskProviderAction;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        /**
* RiskProvider
*/
    @JsonPropertyOrder({
        RiskProvider.JSON_PROPERTY_ACTION,
        RiskProvider.JSON_PROPERTY_CLIENT_ID,
        RiskProvider.JSON_PROPERTY_CREATED,
        RiskProvider.JSON_PROPERTY_ID,
        RiskProvider.JSON_PROPERTY_LAST_UPDATED,
        RiskProvider.JSON_PROPERTY_NAME,
        RiskProvider.JSON_PROPERTY_LINKS
    })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
public class RiskProvider {


        public static final String JSON_PROPERTY_ACTION = "action";
            private RiskProviderAction action = RiskProviderAction.LOG_ONLY;

        public static final String JSON_PROPERTY_CLIENT_ID = "clientId";
            private String clientId;

        public static final String JSON_PROPERTY_CREATED = "created";
            private OffsetDateTime created;

        public static final String JSON_PROPERTY_ID = "id";
            private String id;

        public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
            private OffsetDateTime lastUpdated;

        public static final String JSON_PROPERTY_NAME = "name";
            private String name;

        public static final String JSON_PROPERTY_LINKS = "_links";
            private ApiTokenLink links;

public RiskProvider() { 
}

    /*
    @JsonCreator
    public RiskProvider(
        @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created, 
        @JsonProperty(JSON_PROPERTY_ID) String id, 
        @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated
    ) {
    this();
        this.created = created;
        this.id = id;
        this.lastUpdated = lastUpdated;
    }*/


        public RiskProvider action(RiskProviderAction action) {
        
        this.action = action;
        return this;
        }

    /**
        * Get action
    * @return action
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_ACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public RiskProviderAction getAction() {
        return action;
    }


          @JsonProperty(JSON_PROPERTY_ACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAction(RiskProviderAction action) {
            this.action = action;
        }


        public RiskProvider clientId(String clientId) {
        
        this.clientId = clientId;
        return this;
        }

    /**
        * The ID of the [OAuth service app](https://developer.okta.com/docs/guides/implement-oauth-for-okta-serviceapp/main/#create-a-service-app-and-grant-scopes) that is used to send risk events to Okta
    * @return clientId
    **/
            @javax.annotation.Nonnull
      @ApiModelProperty(required = true, value = "The ID of the [OAuth service app](https://developer.okta.com/docs/guides/implement-oauth-for-okta-serviceapp/main/#create-a-service-app-and-grant-scopes) that is used to send risk events to Okta")
      @JsonProperty(JSON_PROPERTY_CLIENT_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getClientId() {
        return clientId;
    }


          @JsonProperty(JSON_PROPERTY_CLIENT_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setClientId(String clientId) {
            this.clientId = clientId;
        }


    /**
        * Timestamp when the risk provider was created
    * @return created
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "Timestamp when the risk provider was created")
      @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getCreated() {
        return created;
    }




    /**
        * The ID of the risk provider
    * @return id
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "The ID of the risk provider")
      @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }




    /**
        * Timestamp when the risk provider was last updated
    * @return lastUpdated
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "Timestamp when the risk provider was last updated")
      @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }




        public RiskProvider name(String name) {
        
        this.name = name;
        return this;
        }

    /**
        * Name of the risk provider
    * @return name
    **/
            @javax.annotation.Nonnull
      @ApiModelProperty(required = true, value = "Name of the risk provider")
      @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getName() {
        return name;
    }


          @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
            this.name = name;
        }


        public RiskProvider links(ApiTokenLink links) {
        
        this.links = links;
        return this;
        }

    /**
        * Get links
    * @return links
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApiTokenLink getLinks() {
        return links;
    }


          @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLinks(ApiTokenLink links) {
            this.links = links;
        }


@Override
public boolean equals(Object o) {
    if (this == o) {
    return true;
    }
    if (o == null || getClass() != o.getClass()) {
    return false;
    }
        RiskProvider riskProvider = (RiskProvider) o;
        return Objects.equals(this.action, riskProvider.action) &&
        Objects.equals(this.clientId, riskProvider.clientId) &&
        Objects.equals(this.created, riskProvider.created) &&
        Objects.equals(this.id, riskProvider.id) &&
        Objects.equals(this.lastUpdated, riskProvider.lastUpdated) &&
        Objects.equals(this.name, riskProvider.name) &&
        Objects.equals(this.links, riskProvider.links);
}

    @Override
    public int hashCode() {
        return Objects.hash(action, clientId, created, id, lastUpdated, name, links);
    }

    @Override
    public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RiskProvider {\n");
        sb.append("    action: ").append(toIndentedString(action)).append("\n");
        sb.append("    clientId: ").append(toIndentedString(clientId)).append("\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("}");
    return sb.toString();
    }

    /**
    * Convert the given object to string with each line indented by 4 spaces
    * (except the first line).
    */
    private String toIndentedString(Object o) {
    if (o == null) {
    return "null";
    }
    return o.toString().replace("\n", "\n    ");
    }


    }
