package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonInclude;
    import com.fasterxml.jackson.annotation.JsonProperty;
    import com.fasterxml.jackson.annotation.JsonCreator;
    import com.fasterxml.jackson.annotation.JsonTypeName;
    import com.fasterxml.jackson.annotation.JsonValue;
    import io.swagger.annotations.ApiModel;
    import io.swagger.annotations.ApiModelProperty;
    import org.openapitools.client.model.RiskEventSubjectRiskLevel;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        /**
* RiskEventSubject
*/
    @JsonPropertyOrder({
        RiskEventSubject.JSON_PROPERTY_IP,
        RiskEventSubject.JSON_PROPERTY_MESSAGE,
        RiskEventSubject.JSON_PROPERTY_RISK_LEVEL
    })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
public class RiskEventSubject {


        public static final String JSON_PROPERTY_IP = "ip";
            private String ip;

        public static final String JSON_PROPERTY_MESSAGE = "message";
            private String message;

        public static final String JSON_PROPERTY_RISK_LEVEL = "riskLevel";
            private RiskEventSubjectRiskLevel riskLevel;

public RiskEventSubject() { 
}

        public RiskEventSubject ip(String ip) {
        
        this.ip = ip;
        return this;
        }

    /**
        * Either an IpV4 or IpV6 address.
    * @return ip
    **/
            @javax.annotation.Nonnull
      @ApiModelProperty(required = true, value = "Either an IpV4 or IpV6 address.")
      @JsonProperty(JSON_PROPERTY_IP)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getIp() {
        return ip;
    }


          @JsonProperty(JSON_PROPERTY_IP)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIp(String ip) {
            this.ip = ip;
        }


        public RiskEventSubject message(String message) {
        
        this.message = message;
        return this;
        }

    /**
        * Any additional message that the provider can send specifying the reason for the risk level of the IP.
    * @return message
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "Any additional message that the provider can send specifying the reason for the risk level of the IP.")
      @JsonProperty(JSON_PROPERTY_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getMessage() {
        return message;
    }


          @JsonProperty(JSON_PROPERTY_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMessage(String message) {
            this.message = message;
        }


        public RiskEventSubject riskLevel(RiskEventSubjectRiskLevel riskLevel) {
        
        this.riskLevel = riskLevel;
        return this;
        }

    /**
        * Get riskLevel
    * @return riskLevel
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_RISK_LEVEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public RiskEventSubjectRiskLevel getRiskLevel() {
        return riskLevel;
    }


          @JsonProperty(JSON_PROPERTY_RISK_LEVEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRiskLevel(RiskEventSubjectRiskLevel riskLevel) {
            this.riskLevel = riskLevel;
        }


@Override
public boolean equals(Object o) {
    if (this == o) {
    return true;
    }
    if (o == null || getClass() != o.getClass()) {
    return false;
    }
        RiskEventSubject riskEventSubject = (RiskEventSubject) o;
        return Objects.equals(this.ip, riskEventSubject.ip) &&
        Objects.equals(this.message, riskEventSubject.message) &&
        Objects.equals(this.riskLevel, riskEventSubject.riskLevel);
}

    @Override
    public int hashCode() {
        return Objects.hash(ip, message, riskLevel);
    }

    @Override
    public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RiskEventSubject {\n");
        sb.append("    ip: ").append(toIndentedString(ip)).append("\n");
        sb.append("    message: ").append(toIndentedString(message)).append("\n");
        sb.append("    riskLevel: ").append(toIndentedString(riskLevel)).append("\n");
    sb.append("}");
    return sb.toString();
    }

    /**
    * Convert the given object to string with each line indented by 4 spaces
    * (except the first line).
    */
    private String toIndentedString(Object o) {
    if (o == null) {
    return "null";
    }
    return o.toString().replace("\n", "\n    ");
    }


    }
