package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonInclude;
    import com.fasterxml.jackson.annotation.JsonProperty;
    import com.fasterxml.jackson.annotation.JsonCreator;
    import com.fasterxml.jackson.annotation.JsonTypeName;
    import com.fasterxml.jackson.annotation.JsonValue;
    import io.swagger.annotations.ApiModel;
    import io.swagger.annotations.ApiModelProperty;
    import java.time.OffsetDateTime;
    import java.util.ArrayList;
    import java.util.List;
    import org.openapitools.client.model.RiskEventSubject;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        /**
* RiskEvent
*/
    @JsonPropertyOrder({
        RiskEvent.JSON_PROPERTY_EXPIRES_AT,
        RiskEvent.JSON_PROPERTY_SUBJECTS,
        RiskEvent.JSON_PROPERTY_TIMESTAMP
    })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
public class RiskEvent {


        public static final String JSON_PROPERTY_EXPIRES_AT = "expiresAt";
            private OffsetDateTime expiresAt;

        public static final String JSON_PROPERTY_SUBJECTS = "subjects";
            private List<RiskEventSubject> subjects = new ArrayList<>();

        public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
            private OffsetDateTime timestamp;

public RiskEvent() { 
}

        public RiskEvent expiresAt(OffsetDateTime expiresAt) {
        
        this.expiresAt = expiresAt;
        return this;
        }

    /**
        * Time stamp at which the event expires (Expressed as a UTC time zone using ISO 8601 format: yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39;Z&#39;). If this optional field is not included, Okta automatically expires the event 24 hours after the event is consumed.
    * @return expiresAt
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "Time stamp at which the event expires (Expressed as a UTC time zone using ISO 8601 format: yyyy-MM-dd'T'HH:mm:ss.SSS'Z'). If this optional field is not included, Okta automatically expires the event 24 hours after the event is consumed.")
      @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getExpiresAt() {
        return expiresAt;
    }


          @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExpiresAt(OffsetDateTime expiresAt) {
            this.expiresAt = expiresAt;
        }


        public RiskEvent subjects(List<RiskEventSubject> subjects) {
        
        this.subjects = subjects;
        return this;
        }

            public RiskEvent addSubjectsItem(RiskEventSubject subjectsItem) {
                this.subjects.add(subjectsItem);
                return this;
            }

    /**
        * Get subjects
    * @return subjects
    **/
            @javax.annotation.Nonnull
      @ApiModelProperty(required = true, value = "")
      @JsonProperty(JSON_PROPERTY_SUBJECTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public List<RiskEventSubject> getSubjects() {
        return subjects;
    }


          @JsonProperty(JSON_PROPERTY_SUBJECTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSubjects(List<RiskEventSubject> subjects) {
            this.subjects = subjects;
        }


        public RiskEvent timestamp(OffsetDateTime timestamp) {
        
        this.timestamp = timestamp;
        return this;
        }

    /**
        * Time stamp at which the event is produced (Expressed as a UTC time zone using ISO 8601 format: yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39;Z&#39;).
    * @return timestamp
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "Time stamp at which the event is produced (Expressed as a UTC time zone using ISO 8601 format: yyyy-MM-dd'T'HH:mm:ss.SSS'Z').")
      @JsonProperty(JSON_PROPERTY_TIMESTAMP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getTimestamp() {
        return timestamp;
    }


          @JsonProperty(JSON_PROPERTY_TIMESTAMP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimestamp(OffsetDateTime timestamp) {
            this.timestamp = timestamp;
        }


@Override
public boolean equals(Object o) {
    if (this == o) {
    return true;
    }
    if (o == null || getClass() != o.getClass()) {
    return false;
    }
        RiskEvent riskEvent = (RiskEvent) o;
        return Objects.equals(this.expiresAt, riskEvent.expiresAt) &&
        Objects.equals(this.subjects, riskEvent.subjects) &&
        Objects.equals(this.timestamp, riskEvent.timestamp);
}

    @Override
    public int hashCode() {
        return Objects.hash(expiresAt, subjects, timestamp);
    }

    @Override
    public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RiskEvent {\n");
        sb.append("    expiresAt: ").append(toIndentedString(expiresAt)).append("\n");
        sb.append("    subjects: ").append(toIndentedString(subjects)).append("\n");
        sb.append("    timestamp: ").append(toIndentedString(timestamp)).append("\n");
    sb.append("}");
    return sb.toString();
    }

    /**
    * Convert the given object to string with each line indented by 4 spaces
    * (except the first line).
    */
    private String toIndentedString(Object o) {
    if (o == null) {
    return "null";
    }
    return o.toString().replace("\n", "\n    ");
    }


    }
