package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonInclude;
    import com.fasterxml.jackson.annotation.JsonProperty;
    import com.fasterxml.jackson.annotation.JsonCreator;
    import com.fasterxml.jackson.annotation.JsonTypeName;
    import com.fasterxml.jackson.annotation.JsonValue;
    import io.swagger.annotations.ApiModel;
    import io.swagger.annotations.ApiModelProperty;
    import java.time.OffsetDateTime;
    import org.openapitools.client.model.ApiTokenLink;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        /**
* ResourceSetBindingMember
*/
    @JsonPropertyOrder({
        ResourceSetBindingMember.JSON_PROPERTY_CREATED,
        ResourceSetBindingMember.JSON_PROPERTY_ID,
        ResourceSetBindingMember.JSON_PROPERTY_LAST_UPDATED,
        ResourceSetBindingMember.JSON_PROPERTY_LINKS
    })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
public class ResourceSetBindingMember {


        public static final String JSON_PROPERTY_CREATED = "created";
            private OffsetDateTime created;

        public static final String JSON_PROPERTY_ID = "id";
            private String id;

        public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
            private OffsetDateTime lastUpdated;

        public static final String JSON_PROPERTY_LINKS = "_links";
            private ApiTokenLink links;

public ResourceSetBindingMember() { 
}

    /*
    @JsonCreator
    public ResourceSetBindingMember(
        @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created, 
        @JsonProperty(JSON_PROPERTY_ID) String id, 
        @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated
    ) {
    this();
        this.created = created;
        this.id = id;
        this.lastUpdated = lastUpdated;
    }*/


    /**
        * Timestamp when the role was created
    * @return created
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "Timestamp when the role was created")
      @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getCreated() {
        return created;
    }




    /**
        * Unique key for the role
    * @return id
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "Unique key for the role")
      @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }




    /**
        * Timestamp when the role was last updated
    * @return lastUpdated
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "Timestamp when the role was last updated")
      @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }




        public ResourceSetBindingMember links(ApiTokenLink links) {
        
        this.links = links;
        return this;
        }

    /**
        * Get links
    * @return links
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApiTokenLink getLinks() {
        return links;
    }


          @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLinks(ApiTokenLink links) {
            this.links = links;
        }


@Override
public boolean equals(Object o) {
    if (this == o) {
    return true;
    }
    if (o == null || getClass() != o.getClass()) {
    return false;
    }
        ResourceSetBindingMember resourceSetBindingMember = (ResourceSetBindingMember) o;
        return Objects.equals(this.created, resourceSetBindingMember.created) &&
        Objects.equals(this.id, resourceSetBindingMember.id) &&
        Objects.equals(this.lastUpdated, resourceSetBindingMember.lastUpdated) &&
        Objects.equals(this.links, resourceSetBindingMember.links);
}

    @Override
    public int hashCode() {
        return Objects.hash(created, id, lastUpdated, links);
    }

    @Override
    public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ResourceSetBindingMember {\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("}");
    return sb.toString();
    }

    /**
    * Convert the given object to string with each line indented by 4 spaces
    * (except the first line).
    */
    private String toIndentedString(Object o) {
    if (o == null) {
    return "null";
    }
    return o.toString().replace("\n", "\n    ");
    }


    }
