package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets ProtocolAlgorithmTypeSignatureScope
 */
public enum ProtocolAlgorithmTypeSignatureScope {
  
  ANY("ANY"),
  
  NONE("NONE"),
  
  REQUEST("REQUEST"),
  
  RESPONSE("RESPONSE"),
  
  TOKEN("TOKEN");

  private String value;

  ProtocolAlgorithmTypeSignatureScope(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static ProtocolAlgorithmTypeSignatureScope fromValue(String value) {
    for (ProtocolAlgorithmTypeSignatureScope b : ProtocolAlgorithmTypeSignatureScope.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

