package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonInclude;
    import com.fasterxml.jackson.annotation.JsonProperty;
    import com.fasterxml.jackson.annotation.JsonCreator;
    import com.fasterxml.jackson.annotation.JsonTypeName;
    import com.fasterxml.jackson.annotation.JsonValue;
    import io.swagger.annotations.ApiModel;
    import io.swagger.annotations.ApiModelProperty;
    import java.util.HashMap;
    import java.util.Map;
    import org.openapitools.client.model.ProfileMappingProperty;
    import org.openapitools.client.model.ProfileMappingSource;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        /**
* ProfileMapping
*/
    @JsonPropertyOrder({
        ProfileMapping.JSON_PROPERTY_ID,
        ProfileMapping.JSON_PROPERTY_PROPERTIES,
        ProfileMapping.JSON_PROPERTY_SOURCE,
        ProfileMapping.JSON_PROPERTY_TARGET,
        ProfileMapping.JSON_PROPERTY_LINKS
    })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
public class ProfileMapping {


        public static final String JSON_PROPERTY_ID = "id";
            private String id;

        public static final String JSON_PROPERTY_PROPERTIES = "properties";
            private Map<String, ProfileMappingProperty> properties = null;

        public static final String JSON_PROPERTY_SOURCE = "source";
            private ProfileMappingSource source;

        public static final String JSON_PROPERTY_TARGET = "target";
            private ProfileMappingSource target;

        public static final String JSON_PROPERTY_LINKS = "_links";
            private Map<String, Object> links = null;

public ProfileMapping() { 
}

    /*
    @JsonCreator
    public ProfileMapping(
        @JsonProperty(JSON_PROPERTY_ID) String id, 
        @JsonProperty(JSON_PROPERTY_PROPERTIES) Map<String, ProfileMappingProperty> properties, 
        @JsonProperty(JSON_PROPERTY_LINKS) Map<String, Object> links
    ) {
    this();
        this.id = id;
        this.properties = properties;
        this.links = links;
    }*/


    /**
        * Get id
    * @return id
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }




    /**
        * Get properties
    * @return properties
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_PROPERTIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, ProfileMappingProperty> getProperties() {
        return properties;
    }




        public ProfileMapping source(ProfileMappingSource source) {
        
        this.source = source;
        return this;
        }

    /**
        * Get source
    * @return source
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ProfileMappingSource getSource() {
        return source;
    }


          @JsonProperty(JSON_PROPERTY_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSource(ProfileMappingSource source) {
            this.source = source;
        }


        public ProfileMapping target(ProfileMappingSource target) {
        
        this.target = target;
        return this;
        }

    /**
        * Get target
    * @return target
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_TARGET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ProfileMappingSource getTarget() {
        return target;
    }


          @JsonProperty(JSON_PROPERTY_TARGET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTarget(ProfileMappingSource target) {
            this.target = target;
        }


    /**
        * Get links
    * @return links
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, Object> getLinks() {
        return links;
    }




@Override
public boolean equals(Object o) {
    if (this == o) {
    return true;
    }
    if (o == null || getClass() != o.getClass()) {
    return false;
    }
        ProfileMapping profileMapping = (ProfileMapping) o;
        return Objects.equals(this.id, profileMapping.id) &&
        Objects.equals(this.properties, profileMapping.properties) &&
        Objects.equals(this.source, profileMapping.source) &&
        Objects.equals(this.target, profileMapping.target) &&
        Objects.equals(this.links, profileMapping.links);
}

    @Override
    public int hashCode() {
        return Objects.hash(id, properties, source, target, links);
    }

    @Override
    public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProfileMapping {\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
        sb.append("    source: ").append(toIndentedString(source)).append("\n");
        sb.append("    target: ").append(toIndentedString(target)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("}");
    return sb.toString();
    }

    /**
    * Convert the given object to string with each line indented by 4 spaces
    * (except the first line).
    */
    private String toIndentedString(Object o) {
    if (o == null) {
    return "null";
    }
    return o.toString().replace("\n", "\n    ");
    }


    }
