package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets PolicyUserStatus
 */
public enum PolicyUserStatus {
  
  ACTIVATING("ACTIVATING"),
  
  ACTIVE("ACTIVE"),
  
  DELETED("DELETED"),
  
  DELETING("DELETING"),
  
  EXPIRED_PASSWORD("EXPIRED_PASSWORD"),
  
  INACTIVE("INACTIVE"),
  
  PENDING("PENDING"),
  
  SUSPENDED("SUSPENDED");

  private String value;

  PolicyUserStatus(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static PolicyUserStatus fromValue(String value) {
    for (PolicyUserStatus b : PolicyUserStatus.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

