package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets PolicyType
 */
public enum PolicyType {
  
  ACCESS_POLICY("ACCESS_POLICY"),
  
  IDP_DISCOVERY("IDP_DISCOVERY"),
  
  MFA_ENROLL("MFA_ENROLL"),
  
  OAUTH_AUTHORIZATION_POLICY("OAUTH_AUTHORIZATION_POLICY"),
  
  OKTA_SIGN_ON("OKTA_SIGN_ON"),
  
  PASSWORD("PASSWORD"),
  
  PROFILE_ENROLLMENT("PROFILE_ENROLLMENT");

  private String value;

  PolicyType(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static PolicyType fromValue(String value) {
    for (PolicyType b : PolicyType.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

