package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets PolicyRuleType
 */
public enum PolicyRuleType {
  
  ACCESS_POLICY("ACCESS_POLICY"),
  
  IDP_DISCOVERY("IDP_DISCOVERY"),
  
  MFA_ENROLL("MFA_ENROLL"),
  
  PASSWORD("PASSWORD"),
  
  PROFILE_ENROLLMENT("PROFILE_ENROLLMENT"),
  
  RESOURCE_ACCESS("RESOURCE_ACCESS"),
  
  SIGN_ON("SIGN_ON");

  private String value;

  PolicyRuleType(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static PolicyRuleType fromValue(String value) {
    for (PolicyRuleType b : PolicyRuleType.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

