package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
    import com.fasterxml.jackson.annotation.JsonInclude;
    import com.fasterxml.jackson.annotation.JsonProperty;
    import com.fasterxml.jackson.annotation.JsonCreator;
    import com.fasterxml.jackson.annotation.JsonSubTypes;
    import com.fasterxml.jackson.annotation.JsonTypeInfo;
    import com.fasterxml.jackson.annotation.JsonTypeName;
    import com.fasterxml.jackson.annotation.JsonValue;
    import io.swagger.annotations.ApiModel;
    import io.swagger.annotations.ApiModelProperty;
    import java.time.OffsetDateTime;
    import org.openapitools.client.model.AccessPolicyRule;
    import org.openapitools.client.model.AuthorizationServerPolicyRule;
    import org.openapitools.client.model.LifecycleStatus;
    import org.openapitools.client.model.OktaSignOnPolicyRule;
    import org.openapitools.client.model.PasswordPolicyRule;
    import org.openapitools.client.model.PolicyRuleType;
    import org.openapitools.client.model.ProfileEnrollmentPolicyRule;
    import org.openapitools.jackson.nullable.JsonNullable;
    import com.fasterxml.jackson.annotation.JsonIgnore;
    import org.openapitools.jackson.nullable.JsonNullable;
    import java.util.NoSuchElementException;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        /**
* PolicyRule
*/
    @JsonPropertyOrder({
        PolicyRule.JSON_PROPERTY_CREATED,
        PolicyRule.JSON_PROPERTY_ID,
        PolicyRule.JSON_PROPERTY_LAST_UPDATED,
        PolicyRule.JSON_PROPERTY_NAME,
        PolicyRule.JSON_PROPERTY_PRIORITY,
        PolicyRule.JSON_PROPERTY_STATUS,
        PolicyRule.JSON_PROPERTY_SYSTEM,
        PolicyRule.JSON_PROPERTY_TYPE
    })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
public class PolicyRule {


        public static final String JSON_PROPERTY_CREATED = "created";
            private JsonNullable<OffsetDateTime> created = JsonNullable.<OffsetDateTime>undefined();

        public static final String JSON_PROPERTY_ID = "id";
            private String id;

        public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
            private JsonNullable<OffsetDateTime> lastUpdated = JsonNullable.<OffsetDateTime>undefined();

        public static final String JSON_PROPERTY_NAME = "name";
            private String name;

        public static final String JSON_PROPERTY_PRIORITY = "priority";
            private Integer priority;

        public static final String JSON_PROPERTY_STATUS = "status";
            private LifecycleStatus status;

        public static final String JSON_PROPERTY_SYSTEM = "system";
            private Boolean system = false;

        public static final String JSON_PROPERTY_TYPE = "type";
            protected PolicyRuleType type;

public PolicyRule() { 
}

    /*
    @JsonCreator
    public PolicyRule(
        @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created, 
        @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated
    ) {
    this();
        this.created = created;
        this.lastUpdated = lastUpdated;
    }*/


    /**
        * Get created
    * @return created
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
        @JsonIgnore
    
    public OffsetDateTime getCreated() {
        
            if (created == null) {
            created = JsonNullable.<OffsetDateTime>undefined();
            }
        return created.orElse(null);
    }

          @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

        public JsonNullable<OffsetDateTime> getCreated_JsonNullable() {
        return created;
        }
    
        @JsonProperty(JSON_PROPERTY_CREATED)
        private void setCreated_JsonNullable(JsonNullable<OffsetDateTime> created) {
        this.created = created;
        }



        public PolicyRule id(String id) {
        
        this.id = id;
        return this;
        }

    /**
        * Get id
    * @return id
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }


          @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
            this.id = id;
        }


    /**
        * Get lastUpdated
    * @return lastUpdated
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
        @JsonIgnore
    
    public OffsetDateTime getLastUpdated() {
        
            if (lastUpdated == null) {
            lastUpdated = JsonNullable.<OffsetDateTime>undefined();
            }
        return lastUpdated.orElse(null);
    }

          @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

        public JsonNullable<OffsetDateTime> getLastUpdated_JsonNullable() {
        return lastUpdated;
        }
    
        @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
        private void setLastUpdated_JsonNullable(JsonNullable<OffsetDateTime> lastUpdated) {
        this.lastUpdated = lastUpdated;
        }



        public PolicyRule name(String name) {
        
        this.name = name;
        return this;
        }

    /**
        * Get name
    * @return name
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }


          @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
            this.name = name;
        }


        public PolicyRule priority(Integer priority) {
        
        this.priority = priority;
        return this;
        }

    /**
        * Get priority
    * @return priority
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_PRIORITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Integer getPriority() {
        return priority;
    }


          @JsonProperty(JSON_PROPERTY_PRIORITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPriority(Integer priority) {
            this.priority = priority;
        }


        public PolicyRule status(LifecycleStatus status) {
        
        this.status = status;
        return this;
        }

    /**
        * Get status
    * @return status
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LifecycleStatus getStatus() {
        return status;
    }


          @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(LifecycleStatus status) {
            this.status = status;
        }


        public PolicyRule system(Boolean system) {
        
        this.system = system;
        return this;
        }

    /**
        * Get system
    * @return system
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_SYSTEM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getSystem() {
        return system;
    }


          @JsonProperty(JSON_PROPERTY_SYSTEM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSystem(Boolean system) {
            this.system = system;
        }


        public PolicyRule type(PolicyRuleType type) {
        
        this.type = type;
        return this;
        }

    /**
        * Get type
    * @return type
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PolicyRuleType getType() {
        return type;
    }


          @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(PolicyRuleType type) {
            this.type = type;
        }


@Override
public boolean equals(Object o) {
    if (this == o) {
    return true;
    }
    if (o == null || getClass() != o.getClass()) {
    return false;
    }
        PolicyRule policyRule = (PolicyRule) o;
        return equalsNullable(this.created, policyRule.created) &&
        Objects.equals(this.id, policyRule.id) &&
        equalsNullable(this.lastUpdated, policyRule.lastUpdated) &&
        Objects.equals(this.name, policyRule.name) &&
        Objects.equals(this.priority, policyRule.priority) &&
        Objects.equals(this.status, policyRule.status) &&
        Objects.equals(this.system, policyRule.system) &&
        Objects.equals(this.type, policyRule.type);
}

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
        }

    @Override
    public int hashCode() {
        return Objects.hash(hashCodeNullable(created), id, hashCodeNullable(lastUpdated), name, priority, status, system, type);
    }

        private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
        return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
        }

    @Override
    public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PolicyRule {\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    priority: ").append(toIndentedString(priority)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    system: ").append(toIndentedString(system)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
    }

    /**
    * Convert the given object to string with each line indented by 4 spaces
    * (except the first line).
    */
    private String toIndentedString(Object o) {
    if (o == null) {
    return "null";
    }
    return o.toString().replace("\n", "\n    ");
    }


    }
