package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets PolicyPlatformOperatingSystemType
 */
public enum PolicyPlatformOperatingSystemType {
  
  ANDROID("ANDROID"),
  
  ANY("ANY"),
  
  IOS("IOS"),
  
  OSX("OSX"),
  
  OTHER("OTHER"),
  
  WINDOWS("WINDOWS");

  private String value;

  PolicyPlatformOperatingSystemType(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static PolicyPlatformOperatingSystemType fromValue(String value) {
    for (PolicyPlatformOperatingSystemType b : PolicyPlatformOperatingSystemType.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

