package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import io.swagger.annotations.ApiModel;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * The authentication pipeline of the org. &#x60;idx&#x60; means the org is using the Identity Engine, while &#x60;v1&#x60; means the org is using the Classic authentication pipeline.
 */
public enum PipelineType {
  
  IDX("idx"),
  
  V1("v1");

  private String value;

  PipelineType(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static PipelineType fromValue(String value) {
    for (PipelineType b : PipelineType.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

