package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets PerClientRateLimitMode
 */
public enum PerClientRateLimitMode {
  
  DISABLE("DISABLE"),
  
  ENFORCE("ENFORCE"),
  
  PREVIEW("PREVIEW");

  private String value;

  PerClientRateLimitMode(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static PerClientRateLimitMode fromValue(String value) {
    for (PerClientRateLimitMode b : PerClientRateLimitMode.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

