package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets PasswordCredentialHashAlgorithm
 */
public enum PasswordCredentialHashAlgorithm {
  
  BCRYPT("BCRYPT"),
  
  MD5("MD5"),
  
  SHA_1("SHA-1"),
  
  SHA_256("SHA-256"),
  
  SHA_512("SHA-512");

  private String value;

  PasswordCredentialHashAlgorithm(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static PasswordCredentialHashAlgorithm fromValue(String value) {
    for (PasswordCredentialHashAlgorithm b : PasswordCredentialHashAlgorithm.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

