package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import io.swagger.annotations.ApiModel;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Operational status of a given agent
 */
public enum OperationalStatus {
  
  DEGRADED("DEGRADED"),
  
  DISRUPTED("DISRUPTED"),
  
  INACTIVE("INACTIVE"),
  
  OPERATIONAL("OPERATIONAL");

  private String value;

  OperationalStatus(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static OperationalStatus fromValue(String value) {
    for (OperationalStatus b : OperationalStatus.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

