package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonInclude;
    import com.fasterxml.jackson.annotation.JsonProperty;
    import com.fasterxml.jackson.annotation.JsonCreator;
    import com.fasterxml.jackson.annotation.JsonTypeName;
    import com.fasterxml.jackson.annotation.JsonValue;
    import io.swagger.annotations.ApiModel;
    import io.swagger.annotations.ApiModelProperty;
    import org.openapitools.client.model.ApplicationSettingsNotes;
    import org.openapitools.client.model.ApplicationSettingsNotifications;
    import org.openapitools.client.model.OpenIdConnectApplicationSettingsClient;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        /**
* OpenIdConnectApplicationSettings
*/
    @JsonPropertyOrder({
        OpenIdConnectApplicationSettings.JSON_PROPERTY_IDENTITY_STORE_ID,
        OpenIdConnectApplicationSettings.JSON_PROPERTY_IMPLICIT_ASSIGNMENT,
        OpenIdConnectApplicationSettings.JSON_PROPERTY_INLINE_HOOK_ID,
        OpenIdConnectApplicationSettings.JSON_PROPERTY_NOTES,
        OpenIdConnectApplicationSettings.JSON_PROPERTY_NOTIFICATIONS,
        OpenIdConnectApplicationSettings.JSON_PROPERTY_OAUTH_CLIENT
    })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
public class OpenIdConnectApplicationSettings {


        public static final String JSON_PROPERTY_IDENTITY_STORE_ID = "identityStoreId";
            private String identityStoreId;

        public static final String JSON_PROPERTY_IMPLICIT_ASSIGNMENT = "implicitAssignment";
            private Boolean implicitAssignment;

        public static final String JSON_PROPERTY_INLINE_HOOK_ID = "inlineHookId";
            private String inlineHookId;

        public static final String JSON_PROPERTY_NOTES = "notes";
            private ApplicationSettingsNotes notes;

        public static final String JSON_PROPERTY_NOTIFICATIONS = "notifications";
            private ApplicationSettingsNotifications notifications;

        public static final String JSON_PROPERTY_OAUTH_CLIENT = "oauthClient";
            private OpenIdConnectApplicationSettingsClient oauthClient;

public OpenIdConnectApplicationSettings() { 
}

        public OpenIdConnectApplicationSettings identityStoreId(String identityStoreId) {
        
        this.identityStoreId = identityStoreId;
        return this;
        }

    /**
        * Get identityStoreId
    * @return identityStoreId
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_IDENTITY_STORE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getIdentityStoreId() {
        return identityStoreId;
    }


          @JsonProperty(JSON_PROPERTY_IDENTITY_STORE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
        }


        public OpenIdConnectApplicationSettings implicitAssignment(Boolean implicitAssignment) {
        
        this.implicitAssignment = implicitAssignment;
        return this;
        }

    /**
        * Get implicitAssignment
    * @return implicitAssignment
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_IMPLICIT_ASSIGNMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getImplicitAssignment() {
        return implicitAssignment;
    }


          @JsonProperty(JSON_PROPERTY_IMPLICIT_ASSIGNMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImplicitAssignment(Boolean implicitAssignment) {
            this.implicitAssignment = implicitAssignment;
        }


        public OpenIdConnectApplicationSettings inlineHookId(String inlineHookId) {
        
        this.inlineHookId = inlineHookId;
        return this;
        }

    /**
        * Get inlineHookId
    * @return inlineHookId
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_INLINE_HOOK_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getInlineHookId() {
        return inlineHookId;
    }


          @JsonProperty(JSON_PROPERTY_INLINE_HOOK_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInlineHookId(String inlineHookId) {
            this.inlineHookId = inlineHookId;
        }


        public OpenIdConnectApplicationSettings notes(ApplicationSettingsNotes notes) {
        
        this.notes = notes;
        return this;
        }

    /**
        * Get notes
    * @return notes
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_NOTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApplicationSettingsNotes getNotes() {
        return notes;
    }


          @JsonProperty(JSON_PROPERTY_NOTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNotes(ApplicationSettingsNotes notes) {
            this.notes = notes;
        }


        public OpenIdConnectApplicationSettings notifications(ApplicationSettingsNotifications notifications) {
        
        this.notifications = notifications;
        return this;
        }

    /**
        * Get notifications
    * @return notifications
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_NOTIFICATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApplicationSettingsNotifications getNotifications() {
        return notifications;
    }


          @JsonProperty(JSON_PROPERTY_NOTIFICATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNotifications(ApplicationSettingsNotifications notifications) {
            this.notifications = notifications;
        }


        public OpenIdConnectApplicationSettings oauthClient(OpenIdConnectApplicationSettingsClient oauthClient) {
        
        this.oauthClient = oauthClient;
        return this;
        }

    /**
        * Get oauthClient
    * @return oauthClient
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_OAUTH_CLIENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OpenIdConnectApplicationSettingsClient getOauthClient() {
        return oauthClient;
    }


          @JsonProperty(JSON_PROPERTY_OAUTH_CLIENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOauthClient(OpenIdConnectApplicationSettingsClient oauthClient) {
            this.oauthClient = oauthClient;
        }


@Override
public boolean equals(Object o) {
    if (this == o) {
    return true;
    }
    if (o == null || getClass() != o.getClass()) {
    return false;
    }
        OpenIdConnectApplicationSettings openIdConnectApplicationSettings = (OpenIdConnectApplicationSettings) o;
        return Objects.equals(this.identityStoreId, openIdConnectApplicationSettings.identityStoreId) &&
        Objects.equals(this.implicitAssignment, openIdConnectApplicationSettings.implicitAssignment) &&
        Objects.equals(this.inlineHookId, openIdConnectApplicationSettings.inlineHookId) &&
        Objects.equals(this.notes, openIdConnectApplicationSettings.notes) &&
        Objects.equals(this.notifications, openIdConnectApplicationSettings.notifications) &&
        Objects.equals(this.oauthClient, openIdConnectApplicationSettings.oauthClient);
}

    @Override
    public int hashCode() {
        return Objects.hash(identityStoreId, implicitAssignment, inlineHookId, notes, notifications, oauthClient);
    }

    @Override
    public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OpenIdConnectApplicationSettings {\n");
        sb.append("    identityStoreId: ").append(toIndentedString(identityStoreId)).append("\n");
        sb.append("    implicitAssignment: ").append(toIndentedString(implicitAssignment)).append("\n");
        sb.append("    inlineHookId: ").append(toIndentedString(inlineHookId)).append("\n");
        sb.append("    notes: ").append(toIndentedString(notes)).append("\n");
        sb.append("    notifications: ").append(toIndentedString(notifications)).append("\n");
        sb.append("    oauthClient: ").append(toIndentedString(oauthClient)).append("\n");
    sb.append("}");
    return sb.toString();
    }

    /**
    * Convert the given object to string with each line indented by 4 spaces
    * (except the first line).
    */
    private String toIndentedString(Object o) {
    if (o == null) {
    return "null";
    }
    return o.toString().replace("\n", "\n    ");
    }


    }
