package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets OAuthGrantType
 */
public enum OAuthGrantType {
  
  AUTHORIZATION_CODE("authorization_code"),
  
  CLIENT_CREDENTIALS("client_credentials"),
  
  IMPLICIT("implicit"),
  
  INTERACTION_CODE("interaction_code"),
  
  PASSWORD("password"),
  
  REFRESH_TOKEN("refresh_token");

  private String value;

  OAuthGrantType(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static OAuthGrantType fromValue(String value) {
    for (OAuthGrantType b : OAuthGrantType.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

