package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonInclude;
    import com.fasterxml.jackson.annotation.JsonProperty;
    import com.fasterxml.jackson.annotation.JsonCreator;
    import com.fasterxml.jackson.annotation.JsonTypeName;
    import com.fasterxml.jackson.annotation.JsonValue;
    import io.swagger.annotations.ApiModel;
    import io.swagger.annotations.ApiModelProperty;
    import java.time.OffsetDateTime;
    import java.util.ArrayList;
    import java.util.HashMap;
    import java.util.List;
    import java.util.Map;
    import org.openapitools.client.model.GrantOrTokenStatus;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        /**
* OAuth2Token
*/
    @JsonPropertyOrder({
        OAuth2Token.JSON_PROPERTY_CLIENT_ID,
        OAuth2Token.JSON_PROPERTY_CREATED,
        OAuth2Token.JSON_PROPERTY_EXPIRES_AT,
        OAuth2Token.JSON_PROPERTY_ID,
        OAuth2Token.JSON_PROPERTY_ISSUER,
        OAuth2Token.JSON_PROPERTY_LAST_UPDATED,
        OAuth2Token.JSON_PROPERTY_SCOPES,
        OAuth2Token.JSON_PROPERTY_STATUS,
        OAuth2Token.JSON_PROPERTY_USER_ID,
        OAuth2Token.JSON_PROPERTY_EMBEDDED,
        OAuth2Token.JSON_PROPERTY_LINKS
    })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
public class OAuth2Token {


        public static final String JSON_PROPERTY_CLIENT_ID = "clientId";
            private String clientId;

        public static final String JSON_PROPERTY_CREATED = "created";
            private OffsetDateTime created;

        public static final String JSON_PROPERTY_EXPIRES_AT = "expiresAt";
            private OffsetDateTime expiresAt;

        public static final String JSON_PROPERTY_ID = "id";
            private String id;

        public static final String JSON_PROPERTY_ISSUER = "issuer";
            private String issuer;

        public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
            private OffsetDateTime lastUpdated;

        public static final String JSON_PROPERTY_SCOPES = "scopes";
            private List<String> scopes = null;

        public static final String JSON_PROPERTY_STATUS = "status";
            private GrantOrTokenStatus status;

        public static final String JSON_PROPERTY_USER_ID = "userId";
            private String userId;

        public static final String JSON_PROPERTY_EMBEDDED = "_embedded";
            private Map<String, Object> embedded = null;

        public static final String JSON_PROPERTY_LINKS = "_links";
            private Map<String, Object> links = null;

public OAuth2Token() { 
}

    /*
    @JsonCreator
    public OAuth2Token(
        @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created, 
        @JsonProperty(JSON_PROPERTY_EXPIRES_AT) OffsetDateTime expiresAt, 
        @JsonProperty(JSON_PROPERTY_ID) String id, 
        @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated, 
        @JsonProperty(JSON_PROPERTY_EMBEDDED) Map<String, Object> embedded, 
        @JsonProperty(JSON_PROPERTY_LINKS) Map<String, Object> links
    ) {
    this();
        this.created = created;
        this.expiresAt = expiresAt;
        this.id = id;
        this.lastUpdated = lastUpdated;
        this.embedded = embedded;
        this.links = links;
    }*/


        public OAuth2Token clientId(String clientId) {
        
        this.clientId = clientId;
        return this;
        }

    /**
        * Get clientId
    * @return clientId
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_CLIENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getClientId() {
        return clientId;
    }


          @JsonProperty(JSON_PROPERTY_CLIENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClientId(String clientId) {
            this.clientId = clientId;
        }


    /**
        * Get created
    * @return created
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getCreated() {
        return created;
    }




    /**
        * Get expiresAt
    * @return expiresAt
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getExpiresAt() {
        return expiresAt;
    }




    /**
        * Get id
    * @return id
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }




        public OAuth2Token issuer(String issuer) {
        
        this.issuer = issuer;
        return this;
        }

    /**
        * Get issuer
    * @return issuer
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_ISSUER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getIssuer() {
        return issuer;
    }


          @JsonProperty(JSON_PROPERTY_ISSUER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIssuer(String issuer) {
            this.issuer = issuer;
        }


    /**
        * Get lastUpdated
    * @return lastUpdated
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }




        public OAuth2Token scopes(List<String> scopes) {
        
        this.scopes = scopes;
        return this;
        }

            public OAuth2Token addScopesItem(String scopesItem) {
                    if (this.scopes == null) {
                    this.scopes = new ArrayList<>();
                    }
                this.scopes.add(scopesItem);
                return this;
            }

    /**
        * Get scopes
    * @return scopes
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_SCOPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getScopes() {
        return scopes;
    }


          @JsonProperty(JSON_PROPERTY_SCOPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setScopes(List<String> scopes) {
            this.scopes = scopes;
        }


        public OAuth2Token status(GrantOrTokenStatus status) {
        
        this.status = status;
        return this;
        }

    /**
        * Get status
    * @return status
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public GrantOrTokenStatus getStatus() {
        return status;
    }


          @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(GrantOrTokenStatus status) {
            this.status = status;
        }


        public OAuth2Token userId(String userId) {
        
        this.userId = userId;
        return this;
        }

    /**
        * Get userId
    * @return userId
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_USER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getUserId() {
        return userId;
    }


          @JsonProperty(JSON_PROPERTY_USER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserId(String userId) {
            this.userId = userId;
        }


    /**
        * Get embedded
    * @return embedded
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_EMBEDDED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, Object> getEmbedded() {
        return embedded;
    }




    /**
        * Get links
    * @return links
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, Object> getLinks() {
        return links;
    }




@Override
public boolean equals(Object o) {
    if (this == o) {
    return true;
    }
    if (o == null || getClass() != o.getClass()) {
    return false;
    }
        OAuth2Token oauth2Token = (OAuth2Token) o;
        return Objects.equals(this.clientId, oauth2Token.clientId) &&
        Objects.equals(this.created, oauth2Token.created) &&
        Objects.equals(this.expiresAt, oauth2Token.expiresAt) &&
        Objects.equals(this.id, oauth2Token.id) &&
        Objects.equals(this.issuer, oauth2Token.issuer) &&
        Objects.equals(this.lastUpdated, oauth2Token.lastUpdated) &&
        Objects.equals(this.scopes, oauth2Token.scopes) &&
        Objects.equals(this.status, oauth2Token.status) &&
        Objects.equals(this.userId, oauth2Token.userId) &&
        Objects.equals(this.embedded, oauth2Token.embedded) &&
        Objects.equals(this.links, oauth2Token.links);
}

    @Override
    public int hashCode() {
        return Objects.hash(clientId, created, expiresAt, id, issuer, lastUpdated, scopes, status, userId, embedded, links);
    }

    @Override
    public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OAuth2Token {\n");
        sb.append("    clientId: ").append(toIndentedString(clientId)).append("\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    expiresAt: ").append(toIndentedString(expiresAt)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    issuer: ").append(toIndentedString(issuer)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    scopes: ").append(toIndentedString(scopes)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
        sb.append("    embedded: ").append(toIndentedString(embedded)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("}");
    return sb.toString();
    }

    /**
    * Convert the given object to string with each line indented by 4 spaces
    * (except the first line).
    */
    private String toIndentedString(Object o) {
    if (o == null) {
    return "null";
    }
    return o.toString().replace("\n", "\n    ");
    }


    }
