package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets OAuth2ScopeConsentType
 */
public enum OAuth2ScopeConsentType {
  
  ADMIN("ADMIN"),
  
  IMPLICIT("IMPLICIT"),
  
  REQUIRED("REQUIRED");

  private String value;

  OAuth2ScopeConsentType(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static OAuth2ScopeConsentType fromValue(String value) {
    for (OAuth2ScopeConsentType b : OAuth2ScopeConsentType.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

