package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets OAuth2ClaimValueType
 */
public enum OAuth2ClaimValueType {
  
  EXPRESSION("EXPRESSION"),
  
  GROUPS("GROUPS"),
  
  SYSTEM("SYSTEM");

  private String value;

  OAuth2ClaimValueType(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static OAuth2ClaimValueType fromValue(String value) {
    for (OAuth2ClaimValueType b : OAuth2ClaimValueType.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

