package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets OAuth2ClaimGroupFilterType
 */
public enum OAuth2ClaimGroupFilterType {
  
  CONTAINS("CONTAINS"),
  
  EQUALS("EQUALS"),
  
  REGEX("REGEX"),
  
  STARTS_WITH("STARTS_WITH");

  private String value;

  OAuth2ClaimGroupFilterType(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static OAuth2ClaimGroupFilterType fromValue(String value) {
    for (OAuth2ClaimGroupFilterType b : OAuth2ClaimGroupFilterType.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

