package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonInclude;
    import com.fasterxml.jackson.annotation.JsonProperty;
    import com.fasterxml.jackson.annotation.JsonCreator;
    import com.fasterxml.jackson.annotation.JsonTypeName;
    import com.fasterxml.jackson.annotation.JsonValue;
    import io.swagger.annotations.ApiModel;
    import io.swagger.annotations.ApiModelProperty;
    import java.util.HashMap;
    import java.util.Map;
    import org.openapitools.client.model.LifecycleStatus;
    import org.openapitools.client.model.OAuth2ClaimConditions;
    import org.openapitools.client.model.OAuth2ClaimGroupFilterType;
    import org.openapitools.client.model.OAuth2ClaimType;
    import org.openapitools.client.model.OAuth2ClaimValueType;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        /**
* OAuth2Claim
*/
    @JsonPropertyOrder({
        OAuth2Claim.JSON_PROPERTY_ALWAYS_INCLUDE_IN_TOKEN,
        OAuth2Claim.JSON_PROPERTY_CLAIM_TYPE,
        OAuth2Claim.JSON_PROPERTY_CONDITIONS,
        OAuth2Claim.JSON_PROPERTY_GROUP_FILTER_TYPE,
        OAuth2Claim.JSON_PROPERTY_ID,
        OAuth2Claim.JSON_PROPERTY_NAME,
        OAuth2Claim.JSON_PROPERTY_STATUS,
        OAuth2Claim.JSON_PROPERTY_SYSTEM,
        OAuth2Claim.JSON_PROPERTY_VALUE,
        OAuth2Claim.JSON_PROPERTY_VALUE_TYPE,
        OAuth2Claim.JSON_PROPERTY_LINKS
    })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
public class OAuth2Claim {


        public static final String JSON_PROPERTY_ALWAYS_INCLUDE_IN_TOKEN = "alwaysIncludeInToken";
            private Boolean alwaysIncludeInToken;

        public static final String JSON_PROPERTY_CLAIM_TYPE = "claimType";
            private OAuth2ClaimType claimType;

        public static final String JSON_PROPERTY_CONDITIONS = "conditions";
            private OAuth2ClaimConditions conditions;

        public static final String JSON_PROPERTY_GROUP_FILTER_TYPE = "group_filter_type";
            private OAuth2ClaimGroupFilterType groupFilterType;

        public static final String JSON_PROPERTY_ID = "id";
            private String id;

        public static final String JSON_PROPERTY_NAME = "name";
            private String name;

        public static final String JSON_PROPERTY_STATUS = "status";
            private LifecycleStatus status;

        public static final String JSON_PROPERTY_SYSTEM = "system";
            private Boolean system;

        public static final String JSON_PROPERTY_VALUE = "value";
            private String value;

        public static final String JSON_PROPERTY_VALUE_TYPE = "valueType";
            private OAuth2ClaimValueType valueType;

        public static final String JSON_PROPERTY_LINKS = "_links";
            private Map<String, Object> links = null;

public OAuth2Claim() { 
}

    /*
    @JsonCreator
    public OAuth2Claim(
        @JsonProperty(JSON_PROPERTY_ID) String id, 
        @JsonProperty(JSON_PROPERTY_LINKS) Map<String, Object> links
    ) {
    this();
        this.id = id;
        this.links = links;
    }*/


        public OAuth2Claim alwaysIncludeInToken(Boolean alwaysIncludeInToken) {
        
        this.alwaysIncludeInToken = alwaysIncludeInToken;
        return this;
        }

    /**
        * Get alwaysIncludeInToken
    * @return alwaysIncludeInToken
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_ALWAYS_INCLUDE_IN_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getAlwaysIncludeInToken() {
        return alwaysIncludeInToken;
    }


          @JsonProperty(JSON_PROPERTY_ALWAYS_INCLUDE_IN_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAlwaysIncludeInToken(Boolean alwaysIncludeInToken) {
            this.alwaysIncludeInToken = alwaysIncludeInToken;
        }


        public OAuth2Claim claimType(OAuth2ClaimType claimType) {
        
        this.claimType = claimType;
        return this;
        }

    /**
        * Get claimType
    * @return claimType
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_CLAIM_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OAuth2ClaimType getClaimType() {
        return claimType;
    }


          @JsonProperty(JSON_PROPERTY_CLAIM_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClaimType(OAuth2ClaimType claimType) {
            this.claimType = claimType;
        }


        public OAuth2Claim conditions(OAuth2ClaimConditions conditions) {
        
        this.conditions = conditions;
        return this;
        }

    /**
        * Get conditions
    * @return conditions
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_CONDITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OAuth2ClaimConditions getConditions() {
        return conditions;
    }


          @JsonProperty(JSON_PROPERTY_CONDITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setConditions(OAuth2ClaimConditions conditions) {
            this.conditions = conditions;
        }


        public OAuth2Claim groupFilterType(OAuth2ClaimGroupFilterType groupFilterType) {
        
        this.groupFilterType = groupFilterType;
        return this;
        }

    /**
        * Get groupFilterType
    * @return groupFilterType
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_GROUP_FILTER_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OAuth2ClaimGroupFilterType getGroupFilterType() {
        return groupFilterType;
    }


          @JsonProperty(JSON_PROPERTY_GROUP_FILTER_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupFilterType(OAuth2ClaimGroupFilterType groupFilterType) {
            this.groupFilterType = groupFilterType;
        }


    /**
        * Get id
    * @return id
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }




        public OAuth2Claim name(String name) {
        
        this.name = name;
        return this;
        }

    /**
        * Get name
    * @return name
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }


          @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
            this.name = name;
        }


        public OAuth2Claim status(LifecycleStatus status) {
        
        this.status = status;
        return this;
        }

    /**
        * Get status
    * @return status
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LifecycleStatus getStatus() {
        return status;
    }


          @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(LifecycleStatus status) {
            this.status = status;
        }


        public OAuth2Claim system(Boolean system) {
        
        this.system = system;
        return this;
        }

    /**
        * Get system
    * @return system
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_SYSTEM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getSystem() {
        return system;
    }


          @JsonProperty(JSON_PROPERTY_SYSTEM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSystem(Boolean system) {
            this.system = system;
        }


        public OAuth2Claim value(String value) {
        
        this.value = value;
        return this;
        }

    /**
        * Get value
    * @return value
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getValue() {
        return value;
    }


          @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setValue(String value) {
            this.value = value;
        }


        public OAuth2Claim valueType(OAuth2ClaimValueType valueType) {
        
        this.valueType = valueType;
        return this;
        }

    /**
        * Get valueType
    * @return valueType
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_VALUE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OAuth2ClaimValueType getValueType() {
        return valueType;
    }


          @JsonProperty(JSON_PROPERTY_VALUE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setValueType(OAuth2ClaimValueType valueType) {
            this.valueType = valueType;
        }


    /**
        * Get links
    * @return links
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, Object> getLinks() {
        return links;
    }




@Override
public boolean equals(Object o) {
    if (this == o) {
    return true;
    }
    if (o == null || getClass() != o.getClass()) {
    return false;
    }
        OAuth2Claim oauth2Claim = (OAuth2Claim) o;
        return Objects.equals(this.alwaysIncludeInToken, oauth2Claim.alwaysIncludeInToken) &&
        Objects.equals(this.claimType, oauth2Claim.claimType) &&
        Objects.equals(this.conditions, oauth2Claim.conditions) &&
        Objects.equals(this.groupFilterType, oauth2Claim.groupFilterType) &&
        Objects.equals(this.id, oauth2Claim.id) &&
        Objects.equals(this.name, oauth2Claim.name) &&
        Objects.equals(this.status, oauth2Claim.status) &&
        Objects.equals(this.system, oauth2Claim.system) &&
        Objects.equals(this.value, oauth2Claim.value) &&
        Objects.equals(this.valueType, oauth2Claim.valueType) &&
        Objects.equals(this.links, oauth2Claim.links);
}

    @Override
    public int hashCode() {
        return Objects.hash(alwaysIncludeInToken, claimType, conditions, groupFilterType, id, name, status, system, value, valueType, links);
    }

    @Override
    public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OAuth2Claim {\n");
        sb.append("    alwaysIncludeInToken: ").append(toIndentedString(alwaysIncludeInToken)).append("\n");
        sb.append("    claimType: ").append(toIndentedString(claimType)).append("\n");
        sb.append("    conditions: ").append(toIndentedString(conditions)).append("\n");
        sb.append("    groupFilterType: ").append(toIndentedString(groupFilterType)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    system: ").append(toIndentedString(system)).append("\n");
        sb.append("    value: ").append(toIndentedString(value)).append("\n");
        sb.append("    valueType: ").append(toIndentedString(valueType)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("}");
    return sb.toString();
    }

    /**
    * Convert the given object to string with each line indented by 4 spaces
    * (except the first line).
    */
    private String toIndentedString(Object o) {
    if (o == null) {
    return "null";
    }
    return o.toString().replace("\n", "\n    ");
    }


    }
