package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonInclude;
    import com.fasterxml.jackson.annotation.JsonProperty;
    import com.fasterxml.jackson.annotation.JsonCreator;
    import com.fasterxml.jackson.annotation.JsonTypeName;
    import com.fasterxml.jackson.annotation.JsonValue;
    import io.swagger.annotations.ApiModel;
    import io.swagger.annotations.ApiModelProperty;
    import java.time.OffsetDateTime;
    import java.util.ArrayList;
    import java.util.HashMap;
    import java.util.List;
    import java.util.Map;
    import org.openapitools.client.model.NetworkZoneAddress;
    import org.openapitools.client.model.NetworkZoneLocation;
    import org.openapitools.client.model.NetworkZoneStatus;
    import org.openapitools.client.model.NetworkZoneType;
    import org.openapitools.client.model.NetworkZoneUsage;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        /**
* NetworkZone
*/
    @JsonPropertyOrder({
        NetworkZone.JSON_PROPERTY_ASNS,
        NetworkZone.JSON_PROPERTY_CREATED,
        NetworkZone.JSON_PROPERTY_GATEWAYS,
        NetworkZone.JSON_PROPERTY_ID,
        NetworkZone.JSON_PROPERTY_LAST_UPDATED,
        NetworkZone.JSON_PROPERTY_LOCATIONS,
        NetworkZone.JSON_PROPERTY_NAME,
        NetworkZone.JSON_PROPERTY_PROXIES,
        NetworkZone.JSON_PROPERTY_PROXY_TYPE,
        NetworkZone.JSON_PROPERTY_STATUS,
        NetworkZone.JSON_PROPERTY_SYSTEM,
        NetworkZone.JSON_PROPERTY_TYPE,
        NetworkZone.JSON_PROPERTY_USAGE,
        NetworkZone.JSON_PROPERTY_LINKS
    })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
public class NetworkZone {


        public static final String JSON_PROPERTY_ASNS = "asns";
            private List<String> asns = null;

        public static final String JSON_PROPERTY_CREATED = "created";
            private OffsetDateTime created;

        public static final String JSON_PROPERTY_GATEWAYS = "gateways";
            private List<NetworkZoneAddress> gateways = null;

        public static final String JSON_PROPERTY_ID = "id";
            private String id;

        public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
            private OffsetDateTime lastUpdated;

        public static final String JSON_PROPERTY_LOCATIONS = "locations";
            private List<NetworkZoneLocation> locations = null;

        public static final String JSON_PROPERTY_NAME = "name";
            private String name;

        public static final String JSON_PROPERTY_PROXIES = "proxies";
            private List<NetworkZoneAddress> proxies = null;

        public static final String JSON_PROPERTY_PROXY_TYPE = "proxyType";
            private String proxyType;

        public static final String JSON_PROPERTY_STATUS = "status";
            private NetworkZoneStatus status;

        public static final String JSON_PROPERTY_SYSTEM = "system";
            private Boolean system;

        public static final String JSON_PROPERTY_TYPE = "type";
            private NetworkZoneType type;

        public static final String JSON_PROPERTY_USAGE = "usage";
            private NetworkZoneUsage usage;

        public static final String JSON_PROPERTY_LINKS = "_links";
            private Map<String, Object> links = null;

public NetworkZone() { 
}

    /*
    @JsonCreator
    public NetworkZone(
        @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created, 
        @JsonProperty(JSON_PROPERTY_ID) String id, 
        @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated, 
        @JsonProperty(JSON_PROPERTY_LINKS) Map<String, Object> links
    ) {
    this();
        this.created = created;
        this.id = id;
        this.lastUpdated = lastUpdated;
        this.links = links;
    }*/


        public NetworkZone asns(List<String> asns) {
        
        this.asns = asns;
        return this;
        }

            public NetworkZone addAsnsItem(String asnsItem) {
                    if (this.asns == null) {
                    this.asns = new ArrayList<>();
                    }
                this.asns.add(asnsItem);
                return this;
            }

    /**
        * Get asns
    * @return asns
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_ASNS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getAsns() {
        return asns;
    }


          @JsonProperty(JSON_PROPERTY_ASNS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAsns(List<String> asns) {
            this.asns = asns;
        }


    /**
        * Get created
    * @return created
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getCreated() {
        return created;
    }




        public NetworkZone gateways(List<NetworkZoneAddress> gateways) {
        
        this.gateways = gateways;
        return this;
        }

            public NetworkZone addGatewaysItem(NetworkZoneAddress gatewaysItem) {
                    if (this.gateways == null) {
                    this.gateways = new ArrayList<>();
                    }
                this.gateways.add(gatewaysItem);
                return this;
            }

    /**
        * Get gateways
    * @return gateways
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_GATEWAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<NetworkZoneAddress> getGateways() {
        return gateways;
    }


          @JsonProperty(JSON_PROPERTY_GATEWAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGateways(List<NetworkZoneAddress> gateways) {
            this.gateways = gateways;
        }


    /**
        * Get id
    * @return id
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }




    /**
        * Get lastUpdated
    * @return lastUpdated
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }




        public NetworkZone locations(List<NetworkZoneLocation> locations) {
        
        this.locations = locations;
        return this;
        }

            public NetworkZone addLocationsItem(NetworkZoneLocation locationsItem) {
                    if (this.locations == null) {
                    this.locations = new ArrayList<>();
                    }
                this.locations.add(locationsItem);
                return this;
            }

    /**
        * Get locations
    * @return locations
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_LOCATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<NetworkZoneLocation> getLocations() {
        return locations;
    }


          @JsonProperty(JSON_PROPERTY_LOCATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocations(List<NetworkZoneLocation> locations) {
            this.locations = locations;
        }


        public NetworkZone name(String name) {
        
        this.name = name;
        return this;
        }

    /**
        * Get name
    * @return name
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }


          @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
            this.name = name;
        }


        public NetworkZone proxies(List<NetworkZoneAddress> proxies) {
        
        this.proxies = proxies;
        return this;
        }

            public NetworkZone addProxiesItem(NetworkZoneAddress proxiesItem) {
                    if (this.proxies == null) {
                    this.proxies = new ArrayList<>();
                    }
                this.proxies.add(proxiesItem);
                return this;
            }

    /**
        * Get proxies
    * @return proxies
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_PROXIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<NetworkZoneAddress> getProxies() {
        return proxies;
    }


          @JsonProperty(JSON_PROPERTY_PROXIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProxies(List<NetworkZoneAddress> proxies) {
            this.proxies = proxies;
        }


        public NetworkZone proxyType(String proxyType) {
        
        this.proxyType = proxyType;
        return this;
        }

    /**
        * Get proxyType
    * @return proxyType
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_PROXY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getProxyType() {
        return proxyType;
    }


          @JsonProperty(JSON_PROPERTY_PROXY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProxyType(String proxyType) {
            this.proxyType = proxyType;
        }


        public NetworkZone status(NetworkZoneStatus status) {
        
        this.status = status;
        return this;
        }

    /**
        * Get status
    * @return status
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public NetworkZoneStatus getStatus() {
        return status;
    }


          @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(NetworkZoneStatus status) {
            this.status = status;
        }


        public NetworkZone system(Boolean system) {
        
        this.system = system;
        return this;
        }

    /**
        * Get system
    * @return system
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_SYSTEM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getSystem() {
        return system;
    }


          @JsonProperty(JSON_PROPERTY_SYSTEM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSystem(Boolean system) {
            this.system = system;
        }


        public NetworkZone type(NetworkZoneType type) {
        
        this.type = type;
        return this;
        }

    /**
        * Get type
    * @return type
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public NetworkZoneType getType() {
        return type;
    }


          @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(NetworkZoneType type) {
            this.type = type;
        }


        public NetworkZone usage(NetworkZoneUsage usage) {
        
        this.usage = usage;
        return this;
        }

    /**
        * Get usage
    * @return usage
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_USAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public NetworkZoneUsage getUsage() {
        return usage;
    }


          @JsonProperty(JSON_PROPERTY_USAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUsage(NetworkZoneUsage usage) {
            this.usage = usage;
        }


    /**
        * Get links
    * @return links
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, Object> getLinks() {
        return links;
    }




@Override
public boolean equals(Object o) {
    if (this == o) {
    return true;
    }
    if (o == null || getClass() != o.getClass()) {
    return false;
    }
        NetworkZone networkZone = (NetworkZone) o;
        return Objects.equals(this.asns, networkZone.asns) &&
        Objects.equals(this.created, networkZone.created) &&
        Objects.equals(this.gateways, networkZone.gateways) &&
        Objects.equals(this.id, networkZone.id) &&
        Objects.equals(this.lastUpdated, networkZone.lastUpdated) &&
        Objects.equals(this.locations, networkZone.locations) &&
        Objects.equals(this.name, networkZone.name) &&
        Objects.equals(this.proxies, networkZone.proxies) &&
        Objects.equals(this.proxyType, networkZone.proxyType) &&
        Objects.equals(this.status, networkZone.status) &&
        Objects.equals(this.system, networkZone.system) &&
        Objects.equals(this.type, networkZone.type) &&
        Objects.equals(this.usage, networkZone.usage) &&
        Objects.equals(this.links, networkZone.links);
}

    @Override
    public int hashCode() {
        return Objects.hash(asns, created, gateways, id, lastUpdated, locations, name, proxies, proxyType, status, system, type, usage, links);
    }

    @Override
    public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class NetworkZone {\n");
        sb.append("    asns: ").append(toIndentedString(asns)).append("\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    gateways: ").append(toIndentedString(gateways)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    locations: ").append(toIndentedString(locations)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    proxies: ").append(toIndentedString(proxies)).append("\n");
        sb.append("    proxyType: ").append(toIndentedString(proxyType)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    system: ").append(toIndentedString(system)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("    usage: ").append(toIndentedString(usage)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("}");
    return sb.toString();
    }

    /**
    * Convert the given object to string with each line indented by 4 spaces
    * (except the first line).
    */
    private String toIndentedString(Object o) {
    if (o == null) {
    return "null";
    }
    return o.toString().replace("\n", "\n    ");
    }


    }
