package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets MultifactorEnrollmentPolicyAuthenticatorType
 */
public enum MultifactorEnrollmentPolicyAuthenticatorType {
  
  CUSTOM_APP("custom_app"),
  
  CUSTOM_OTP("custom_otp"),
  
  DUO("duo"),
  
  EXTERNAL_IDP("external_idp"),
  
  GOOGLE_OTP("google_otp"),
  
  OKTA_EMAIL("okta_email"),
  
  OKTA_PASSWORD("okta_password"),
  
  OKTA_VERIFY("okta_verify"),
  
  ONPREM_MFA("onprem_mfa"),
  
  PHONE_NUMBER("phone_number"),
  
  RSA_TOKEN("rsa_token"),
  
  SECURITY_QUESTION("security_question"),
  
  SYMANTEC_VIP("symantec_vip"),
  
  WEBAUTHN("webauthn"),
  
  YUBIKEY_TOKEN("yubikey_token");

  private String value;

  MultifactorEnrollmentPolicyAuthenticatorType(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static MultifactorEnrollmentPolicyAuthenticatorType fromValue(String value) {
    for (MultifactorEnrollmentPolicyAuthenticatorType b : MultifactorEnrollmentPolicyAuthenticatorType.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

