package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets LogCredentialType
 */
public enum LogCredentialType {
  
  ASSERTION("ASSERTION"),
  
  EMAIL("EMAIL"),
  
  IWA("IWA"),
  
  JWT("JWT"),
  
  OAUTH_2_0("OAuth 2.0"),
  
  OTP("OTP"),
  
  PASSWORD("PASSWORD"),
  
  SMS("SMS");

  private String value;

  LogCredentialType(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static LogCredentialType fromValue(String value) {
    for (LogCredentialType b : LogCredentialType.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

