package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets LogAuthenticationProvider
 */
public enum LogAuthenticationProvider {
  
  ACTIVE_DIRECTORY("ACTIVE_DIRECTORY"),
  
  FACTOR_PROVIDER("FACTOR_PROVIDER"),
  
  FEDERATION("FEDERATION"),
  
  LDAP("LDAP"),
  
  OKTA_AUTHENTICATION_PROVIDER("OKTA_AUTHENTICATION_PROVIDER"),
  
  SOCIAL("SOCIAL");

  private String value;

  LogAuthenticationProvider(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static LogAuthenticationProvider fromValue(String value) {
    for (LogAuthenticationProvider b : LogAuthenticationProvider.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

