package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets LocationGranularity
 */
public enum LocationGranularity {
  
  CITY("CITY"),
  
  COUNTRY("COUNTRY"),
  
  LAT_LONG("LAT_LONG"),
  
  SUBDIVISION("SUBDIVISION");

  private String value;

  LocationGranularity(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static LocationGranularity fromValue(String value) {
    for (LocationGranularity b : LocationGranularity.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

