package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets InlineHookType
 */
public enum InlineHookType {
  
  IMPORT_TRANSFORM("com.okta.import.transform"),
  
  OAUTH2_TOKENS_TRANSFORM("com.okta.oauth2.tokens.transform"),
  
  SAML_TOKENS_TRANSFORM("com.okta.saml.tokens.transform"),
  
  USER_CREDENTIAL_PASSWORD_IMPORT("com.okta.user.credential.password.import"),
  
  USER_PRE_REGISTRATION("com.okta.user.pre-registration");

  private String value;

  InlineHookType(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static InlineHookType fromValue(String value) {
    for (InlineHookType b : InlineHookType.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

