package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets IdentityProviderType
 */
public enum IdentityProviderType {
  
  AGENTLESSDSSO("AgentlessDSSO"),
  
  FACEBOOK("FACEBOOK"),
  
  GOOGLE("GOOGLE"),
  
  IWA("IWA"),
  
  LINKEDIN("LINKEDIN"),
  
  MICROSOFT("MICROSOFT"),
  
  OIDC("OIDC"),
  
  OKTA("OKTA"),
  
  SAML2("SAML2"),
  
  X509("X509");

  private String value;

  IdentityProviderType(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static IdentityProviderType fromValue(String value) {
    for (IdentityProviderType b : IdentityProviderType.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

