package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets IdentityProviderCredentialsTrustRevocation
 */
public enum IdentityProviderCredentialsTrustRevocation {
  
  CRL("CRL"),
  
  DELTA_CRL("DELTA_CRL"),
  
  OCSP("OCSP");

  private String value;

  IdentityProviderCredentialsTrustRevocation(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static IdentityProviderCredentialsTrustRevocation fromValue(String value) {
    for (IdentityProviderCredentialsTrustRevocation b : IdentityProviderCredentialsTrustRevocation.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

