package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonInclude;
    import com.fasterxml.jackson.annotation.JsonProperty;
    import com.fasterxml.jackson.annotation.JsonCreator;
    import com.fasterxml.jackson.annotation.JsonTypeName;
    import com.fasterxml.jackson.annotation.JsonValue;
    import io.swagger.annotations.ApiModel;
    import io.swagger.annotations.ApiModelProperty;
    import java.time.OffsetDateTime;
    import java.util.HashMap;
    import java.util.Map;
    import org.openapitools.client.model.IdentityProviderPolicy;
    import org.openapitools.client.model.IdentityProviderType;
    import org.openapitools.client.model.IssuerMode;
    import org.openapitools.client.model.LifecycleStatus;
    import org.openapitools.client.model.Protocol;
    import org.openapitools.jackson.nullable.JsonNullable;
    import com.fasterxml.jackson.annotation.JsonIgnore;
    import org.openapitools.jackson.nullable.JsonNullable;
    import java.util.NoSuchElementException;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        /**
* IdentityProvider
*/
    @JsonPropertyOrder({
        IdentityProvider.JSON_PROPERTY_CREATED,
        IdentityProvider.JSON_PROPERTY_ID,
        IdentityProvider.JSON_PROPERTY_ISSUER_MODE,
        IdentityProvider.JSON_PROPERTY_LAST_UPDATED,
        IdentityProvider.JSON_PROPERTY_NAME,
        IdentityProvider.JSON_PROPERTY_POLICY,
        IdentityProvider.JSON_PROPERTY_PROTOCOL,
        IdentityProvider.JSON_PROPERTY_STATUS,
        IdentityProvider.JSON_PROPERTY_TYPE,
        IdentityProvider.JSON_PROPERTY_LINKS
    })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
public class IdentityProvider {


        public static final String JSON_PROPERTY_CREATED = "created";
            private JsonNullable<OffsetDateTime> created = JsonNullable.<OffsetDateTime>undefined();

        public static final String JSON_PROPERTY_ID = "id";
            private String id;

        public static final String JSON_PROPERTY_ISSUER_MODE = "issuerMode";
            private IssuerMode issuerMode;

        public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
            private OffsetDateTime lastUpdated;

        public static final String JSON_PROPERTY_NAME = "name";
            private String name;

        public static final String JSON_PROPERTY_POLICY = "policy";
            private IdentityProviderPolicy policy;

        public static final String JSON_PROPERTY_PROTOCOL = "protocol";
            private Protocol protocol;

        public static final String JSON_PROPERTY_STATUS = "status";
            private LifecycleStatus status;

        public static final String JSON_PROPERTY_TYPE = "type";
            private IdentityProviderType type;

        public static final String JSON_PROPERTY_LINKS = "_links";
            private Map<String, Object> links = null;

public IdentityProvider() { 
}

    /*
    @JsonCreator
    public IdentityProvider(
        @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created, 
        @JsonProperty(JSON_PROPERTY_ID) String id, 
        @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated, 
        @JsonProperty(JSON_PROPERTY_LINKS) Map<String, Object> links
    ) {
    this();
        this.created = created;
        this.id = id;
        this.lastUpdated = lastUpdated;
        this.links = links;
    }*/


    /**
        * Get created
    * @return created
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
        @JsonIgnore
    
    public OffsetDateTime getCreated() {
        
            if (created == null) {
            created = JsonNullable.<OffsetDateTime>undefined();
            }
        return created.orElse(null);
    }

          @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

        public JsonNullable<OffsetDateTime> getCreated_JsonNullable() {
        return created;
        }
    
        @JsonProperty(JSON_PROPERTY_CREATED)
        private void setCreated_JsonNullable(JsonNullable<OffsetDateTime> created) {
        this.created = created;
        }



    /**
        * Get id
    * @return id
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }




        public IdentityProvider issuerMode(IssuerMode issuerMode) {
        
        this.issuerMode = issuerMode;
        return this;
        }

    /**
        * Get issuerMode
    * @return issuerMode
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_ISSUER_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public IssuerMode getIssuerMode() {
        return issuerMode;
    }


          @JsonProperty(JSON_PROPERTY_ISSUER_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIssuerMode(IssuerMode issuerMode) {
            this.issuerMode = issuerMode;
        }


    /**
        * Get lastUpdated
    * @return lastUpdated
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }




        public IdentityProvider name(String name) {
        
        this.name = name;
        return this;
        }

    /**
        * Get name
    * @return name
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }


          @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
            this.name = name;
        }


        public IdentityProvider policy(IdentityProviderPolicy policy) {
        
        this.policy = policy;
        return this;
        }

    /**
        * Get policy
    * @return policy
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public IdentityProviderPolicy getPolicy() {
        return policy;
    }


          @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPolicy(IdentityProviderPolicy policy) {
            this.policy = policy;
        }


        public IdentityProvider protocol(Protocol protocol) {
        
        this.protocol = protocol;
        return this;
        }

    /**
        * Get protocol
    * @return protocol
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_PROTOCOL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Protocol getProtocol() {
        return protocol;
    }


          @JsonProperty(JSON_PROPERTY_PROTOCOL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProtocol(Protocol protocol) {
            this.protocol = protocol;
        }


        public IdentityProvider status(LifecycleStatus status) {
        
        this.status = status;
        return this;
        }

    /**
        * Get status
    * @return status
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LifecycleStatus getStatus() {
        return status;
    }


          @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(LifecycleStatus status) {
            this.status = status;
        }


        public IdentityProvider type(IdentityProviderType type) {
        
        this.type = type;
        return this;
        }

    /**
        * Get type
    * @return type
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public IdentityProviderType getType() {
        return type;
    }


          @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(IdentityProviderType type) {
            this.type = type;
        }


    /**
        * Get links
    * @return links
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, Object> getLinks() {
        return links;
    }




@Override
public boolean equals(Object o) {
    if (this == o) {
    return true;
    }
    if (o == null || getClass() != o.getClass()) {
    return false;
    }
        IdentityProvider identityProvider = (IdentityProvider) o;
        return equalsNullable(this.created, identityProvider.created) &&
        Objects.equals(this.id, identityProvider.id) &&
        Objects.equals(this.issuerMode, identityProvider.issuerMode) &&
        Objects.equals(this.lastUpdated, identityProvider.lastUpdated) &&
        Objects.equals(this.name, identityProvider.name) &&
        Objects.equals(this.policy, identityProvider.policy) &&
        Objects.equals(this.protocol, identityProvider.protocol) &&
        Objects.equals(this.status, identityProvider.status) &&
        Objects.equals(this.type, identityProvider.type) &&
        Objects.equals(this.links, identityProvider.links);
}

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
        }

    @Override
    public int hashCode() {
        return Objects.hash(hashCodeNullable(created), id, issuerMode, lastUpdated, name, policy, protocol, status, type, links);
    }

        private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
        return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
        }

    @Override
    public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IdentityProvider {\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    issuerMode: ").append(toIndentedString(issuerMode)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    policy: ").append(toIndentedString(policy)).append("\n");
        sb.append("    protocol: ").append(toIndentedString(protocol)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("}");
    return sb.toString();
    }

    /**
    * Convert the given object to string with each line indented by 4 spaces
    * (except the first line).
    */
    private String toIndentedString(Object o) {
    if (o == null) {
    return "null";
    }
    return o.toString().replace("\n", "\n    ");
    }


    }
