package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets FactorStatus
 */
public enum FactorStatus {
  
  ACTIVE("ACTIVE"),
  
  DISABLED("DISABLED"),
  
  ENROLLED("ENROLLED"),
  
  EXPIRED("EXPIRED"),
  
  INACTIVE("INACTIVE"),
  
  NOT_SETUP("NOT_SETUP"),
  
  PENDING_ACTIVATION("PENDING_ACTIVATION");

  private String value;

  FactorStatus(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static FactorStatus fromValue(String value) {
    for (FactorStatus b : FactorStatus.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

